/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.WorkingSet;
import charactermanaj.model.io.CharacterDataXMLWriter;
import charactermanaj.ui.model.WallpaperInfo;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetXMLWriter {
    private static final String VERSION_SIG_1_0 = "1.0";
    private static final String NS = "http://charactermanaj.sourceforge.jp/schema/charactermanaj-workingset";
    private CharacterDataXMLWriter characterDataXmlWriter = new CharacterDataXMLWriter("http://charactermanaj.sourceforge.jp/schema/charactermanaj-workingset");

    public void writeWorkingSet(WorkingSet ws, OutputStream outstm) throws IOException {
        Transformer tfmr;
        if (ws == null || outstm == null) {
            throw new IllegalArgumentException();
        }
        Document doc = this.createWorkingSetXML(ws);
        TransformerFactory txFactory = TransformerFactory.newInstance();
        txFactory.setAttribute("indent-number", 4);
        try {
            tfmr = txFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        tfmr.setOutputProperty("indent", "yes");
        String encoding = "UTF-8";
        tfmr.setOutputProperty("encoding", "UTF-8");
        try {
            tfmr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(outstm, Charset.forName("UTF-8"))));
        }
        catch (TransformerException ex) {
            IOException ex2 = new IOException("XML Convert failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    public Document createWorkingSetXML(WorkingSet ws) {
        Document doc;
        if (ws == null) {
            throw new IllegalArgumentException();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration failed.", ex);
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        Element root = doc.createElementNS(NS, "character-workingset");
        root.setAttribute("version", VERSION_SIG_1_0);
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xsi:schemaLocation", "http://charactermanaj.sourceforge.jp/schema/charactermanaj-workingset character_ws.xsd");
        URI docbase = ws.getCharacterDocBase();
        root.setAttribute("characterDocBase", docbase == null ? "" : docbase.toString());
        CharacterData cd = ws.getCharacterData();
        Element characterDataSigElm = doc.createElementNS(NS, "characterDataSig");
        if (cd == null || !cd.isValid()) {
            characterDataSigElm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        } else {
            characterDataSigElm.setTextContent(cd.toSignatureString());
        }
        root.appendChild(characterDataSigElm);
        root.appendChild(this.writePartsColorInfoMap(doc, ws.getPartsColorInfoMap()));
        PartsSet currentPartsSet = ws.getPartsSet();
        Element partsSetElm = doc.createElementNS(NS, "currentPartsSet");
        if (currentPartsSet == null || currentPartsSet.isEmpty()) {
            partsSetElm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        } else {
            Element elm = this.characterDataXmlWriter.createPartsSetXML(doc, lang, currentPartsSet);
            partsSetElm.appendChild(elm);
        }
        root.appendChild(partsSetElm);
        Element lastUsedSaveDirElm = doc.createElementNS(NS, "lastUsedSaveDir");
        File lastUsedSaveDir = ws.getLastUsedSaveDir();
        if (lastUsedSaveDir == null) {
            lastUsedSaveDirElm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        } else {
            lastUsedSaveDirElm.setTextContent(lastUsedSaveDir.getPath());
        }
        root.appendChild(lastUsedSaveDirElm);
        Element lastUsedExportDirElm = doc.createElementNS(NS, "lastUsedExportDir");
        File lastUsedExportDir = ws.getLastUsedExportDir();
        if (lastUsedExportDir == null) {
            lastUsedExportDirElm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        } else {
            lastUsedExportDirElm.setTextContent(lastUsedExportDir.getPath());
        }
        root.appendChild(lastUsedExportDirElm);
        PartsSet lastUsePresetParts = ws.getLastUsePresetParts();
        Element lastUsePresetPartsElm = doc.createElementNS(NS, "lastUsePresetParts");
        if (lastUsePresetParts == null || lastUsePresetParts.isEmpty()) {
            lastUsePresetPartsElm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        } else {
            Element elm = this.characterDataXmlWriter.createPartsSetXML(doc, lang, lastUsePresetParts);
            lastUsePresetPartsElm.appendChild(elm);
        }
        root.appendChild(lastUsePresetPartsElm);
        root.appendChild(this.writeWallpaper(doc, ws.getWallpaperInfo()));
        doc.appendChild(root);
        return doc;
    }

    public Element writePartsColorInfoMap(Document doc, Map<PartsIdentifier, PartsColorInfo> partsColorMap) {
        Element partsColorInfoMapElm = doc.createElementNS(NS, "partsColorInfoMap");
        if (partsColorMap != null) {
            LinkedHashMap<PartsColorInfo, String> colorMap = new LinkedHashMap<PartsColorInfo, String>();
            for (Map.Entry<PartsIdentifier, PartsColorInfo> partsColorEntry : partsColorMap.entrySet()) {
                PartsColorInfo partsColorInfo = partsColorEntry.getValue();
                if (partsColorInfo == null || partsColorInfo.isEmpty() || colorMap.containsKey(partsColorInfo)) continue;
                colorMap.put(partsColorInfo, Integer.toString(colorMap.size() + 1));
            }
            Element colorsElm = doc.createElementNS(NS, "colors");
            for (Map.Entry entry : colorMap.entrySet()) {
                PartsColorInfo partsColorInfo = (PartsColorInfo)entry.getKey();
                String id = (String)entry.getValue();
                Element partsColorElm = this.characterDataXmlWriter.createPartsColorInfoXML(doc, partsColorInfo);
                partsColorElm.setAttribute("id", id);
                colorsElm.appendChild(partsColorElm);
            }
            partsColorInfoMapElm.appendChild(colorsElm);
            Element partsListElm = doc.createElementNS(NS, "partsList");
            for (Map.Entry<PartsIdentifier, PartsColorInfo> partsColorEntry : partsColorMap.entrySet()) {
                PartsIdentifier partsIdentifier = partsColorEntry.getKey();
                PartsColorInfo partsColorInfo = partsColorEntry.getValue();
                if (partsColorInfo == null || partsColorInfo.isEmpty()) continue;
                String colorId = (String)colorMap.get(partsColorInfo);
                if (colorId == null) {
                    throw new RuntimeException("colorMap\u304c\u4e0d\u6574\u5408\u3067\u3059");
                }
                Element partsElm = doc.createElementNS(NS, "partsIdentifier");
                String categoryId = partsIdentifier.getPartsCategory().getCategoryId();
                partsElm.setAttribute("categoryId", categoryId);
                partsElm.setAttribute("name", partsIdentifier.getPartsName());
                partsElm.setAttribute("colorId", colorId);
                partsListElm.appendChild(partsElm);
            }
            partsColorInfoMapElm.appendChild(partsListElm);
        }
        return partsColorInfoMapElm;
    }

    public Element writeWallpaper(Document doc, WallpaperInfo wallpaperInfo) {
        Element elm = doc.createElementNS(NS, "wallpaperInfo");
        if (wallpaperInfo == null) {
            elm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        } else {
            WallpaperInfo.WallpaperResourceType typ = wallpaperInfo.getType();
            Element typElm = doc.createElementNS(NS, "type");
            typElm.setTextContent(typ.name());
            elm.appendChild(typElm);
            String res = wallpaperInfo.getResource();
            Element resElm = doc.createElementNS(NS, "resource");
            if (res == null || res.trim().length() == 0) {
                resElm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            } else {
                resElm.setTextContent(res);
            }
            elm.appendChild(resElm);
            File file = wallpaperInfo.getFile();
            Element fileElm = doc.createElementNS(NS, "file");
            if (file == null) {
                fileElm.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            } else {
                fileElm.setTextContent(file.getPath());
            }
            elm.appendChild(fileElm);
            float alpha = wallpaperInfo.getAlpha();
            Element alphaElm = doc.createElementNS(NS, "alpha");
            alphaElm.setTextContent(Float.toString(alpha));
            elm.appendChild(alphaElm);
            Color backgroundColor = wallpaperInfo.getBackgroundColor();
            Element bgColorElm = doc.createElementNS(NS, "backgroundColor");
            bgColorElm.setTextContent("#" + Integer.toHexString(backgroundColor.getRGB() & 0xFFFFFF));
            elm.appendChild(bgColorElm);
        }
        return elm;
    }
}

