/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.AppConfig;
import charactermanaj.model.util.StartupSupport;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

class PurgeOldLogs
extends StartupSupport {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    PurgeOldLogs() {
    }

    public void doStartup() {
        AppConfig appConfig;
        long purgeOldLogsMillSec;
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        File logsDir = userDataFactory.getSpecialDataDir("*.log");
        if (logsDir.exists() && (purgeOldLogsMillSec = (appConfig = AppConfig.getInstance()).getPurgeLogDays() * 24L * 3600L * 1000L) > 0L) {
            File[] files = logsDir.listFiles();
            if (files == null) {
                this.logger.log(Level.WARNING, "log-dir access failed.");
                return;
            }
            long purgeThresold = System.currentTimeMillis() - purgeOldLogsMillSec;
            for (File file : files) {
                try {
                    long lastModified;
                    String name = file.getName();
                    if (!file.isFile() || !file.canWrite() || !name.endsWith(".log") || (lastModified = file.lastModified()) <= 0L || lastModified >= purgeThresold) continue;
                    boolean result = file.delete();
                    this.logger.log(Level.INFO, "remove file " + file + "/succeeded=" + result);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "remove file failed. " + file, ex);
                }
            }
        }
    }
}

