/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSpec;
import charactermanaj.ui.ImportPartsImageSet;

class ImportPartsModel {
    private PartsIdentifier partsIdentifier;
    private PartsAuthorInfo authorInfo;
    private PartsManageData.PartsVersionInfo versionInfo;
    private PartsSpec partsSpecAtCurrent;
    private ImportPartsImageSet imageSet;
    private int numOfLink;
    private Long lastModifiedAtCurrentProfile;

    public ImportPartsModel(PartsIdentifier partsIdentifier, PartsAuthorInfo authorInfo, PartsManageData.PartsVersionInfo versionInfo, PartsSpec partsSpecAtCurrent, ImportPartsImageSet imageSet, int numOfLink) {
        if (partsIdentifier == null || imageSet == null) {
            throw new IllegalArgumentException();
        }
        this.partsIdentifier = partsIdentifier;
        this.authorInfo = authorInfo;
        this.versionInfo = versionInfo;
        this.partsSpecAtCurrent = partsSpecAtCurrent;
        this.imageSet = imageSet;
        this.numOfLink = numOfLink;
        this.lastModifiedAtCurrentProfile = partsSpecAtCurrent != null ? Long.valueOf(partsSpecAtCurrent.getPartsFiles().lastModified()) : null;
    }

    public int getNumOfLink() {
        return this.numOfLink;
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    public ImportPartsImageSet getImageSet() {
        return this.imageSet;
    }

    public String getPartsName() {
        return this.partsIdentifier.getLocalizedPartsName();
    }

    public String getAuthor() {
        if (this.authorInfo != null) {
            return this.authorInfo.getAuthor();
        }
        return null;
    }

    public String getAuthorAtCurrent() {
        PartsAuthorInfo partsAuthorInfo;
        if (this.partsSpecAtCurrent != null && (partsAuthorInfo = this.partsSpecAtCurrent.getAuthorInfo()) != null) {
            return partsAuthorInfo.getAuthor();
        }
        return null;
    }

    public double getVersion() {
        if (this.versionInfo != null) {
            return this.versionInfo.getVersion();
        }
        return 0.0;
    }

    public double getVersionAtCurrent() {
        if (this.partsSpecAtCurrent != null) {
            return this.partsSpecAtCurrent.getVersion();
        }
        return 0.0;
    }

    public PartsCategory getPartsCategory() {
        return this.partsIdentifier.getPartsCategory();
    }

    public void setChecked(boolean checked) {
        this.imageSet.setChecked(checked);
    }

    public boolean isChecked() {
        return this.imageSet.isChecked();
    }

    public int getWidth() {
        return this.imageSet.getWidth();
    }

    public int getHeight() {
        return this.imageSet.getHeight();
    }

    public boolean isUnmatchedSize() {
        return this.imageSet.isUnmatchedSize();
    }

    public boolean isAlphaColor() {
        return this.imageSet.isAlphaColor();
    }

    public long getLastModified() {
        return this.imageSet.lastModified();
    }

    public Long getLastModifiedAtCurrentProfile() {
        return this.lastModifiedAtCurrentProfile;
    }
}

