/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndependentPartsColorInfo
implements Serializable {
    private static final long serialVersionUID = -8114086036157411198L;
    private static final Logger logger = Logger.getLogger(IndependentPartsColorInfo.class.getName());
    private String layerId;
    private String colorGroupId;
    private boolean syncColorGroup;
    private ColorConvertParameter colorConvertParameter = new ColorConvertParameter();

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public void setColorGroupId(String colorGroupId) {
        this.colorGroupId = colorGroupId;
    }

    public String getColorGroupId() {
        return this.colorGroupId;
    }

    public void setSyncColorGroup(boolean syncColorGroup) {
        this.syncColorGroup = syncColorGroup;
    }

    public boolean isSyncColorGroup() {
        return this.syncColorGroup;
    }

    public void setColorConvertParameter(ColorConvertParameter colorConvertParameter) {
        this.colorConvertParameter = colorConvertParameter;
    }

    public ColorConvertParameter getColorConvertParameter() {
        return this.colorConvertParameter;
    }

    public static PartsColorInfo buildPartsColorInfo(CharacterData characterData, PartsCategory category, List<IndependentPartsColorInfo> partsColorInfoList) {
        if (characterData == null || category == null) {
            throw new IllegalArgumentException();
        }
        if (partsColorInfoList == null) {
            return null;
        }
        AbstractMap partsColorInfo = null;
        for (IndependentPartsColorInfo info : partsColorInfoList) {
            String layerId = info.getLayerId();
            Layer layer = category.getLayer(layerId);
            if (layer == null) {
                logger.log(Level.WARNING, "undefined layer: " + layerId);
                break;
            }
            if (partsColorInfo == null) {
                partsColorInfo = new PartsColorInfo(category);
            }
            ColorInfo colorInfo = (ColorInfo)partsColorInfo.get(layer);
            String colorGroupId = info.getColorGroupId();
            ColorGroup colorGroup = characterData.getColorGroup(colorGroupId);
            boolean syncColorGroup = info.isSyncColorGroup();
            colorInfo.setColorGroup(colorGroup);
            colorInfo.setSyncColorGroup(syncColorGroup);
            colorInfo.setColorParameter(info.getColorConvertParameter());
        }
        return partsColorInfo;
    }
}

