/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.colormodel.ColorModels;
import charactermanaj.graphics.filters.ColorConv;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.IndependentPartsColorInfo;
import charactermanaj.model.IndependentPartsSetInfo;
import charactermanaj.model.IndependentPartsSetInfoList;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsSet;
import charactermanaj.model.RecommendationURL;
import charactermanaj.util.XMLUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterDataXMLReader {
    private static final String NS_PREFIX = "http://charactermanaj.sourceforge.jp/schema/charactermanaj";
    private static final String NS_PREFIX_FAVORITES = "http://charactermanaj.sourceforge.jp/schema/charactermanaj";
    private static final Logger logger = Logger.getLogger(CharacterDataXMLReader.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterData loadCharacterDataFromXML(URI docBase) throws IOException {
        CharacterData cd;
        if (docBase == null) {
            throw new IllegalArgumentException();
        }
        URL docBaseURL = docBase.toURL();
        InputStream is = docBaseURL.openStream();
        try {
            cd = this.loadCharacterDataFromXML(is, docBase);
        }
        finally {
            is.close();
        }
        return cd;
    }

    public CharacterData loadCharacterDataFromXML(InputStream is, URI docBase) throws IOException {
        return this.loadCharacterDataFromXML(is, docBase, Locale.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public CharacterData loadCharacterDataFromXML(InputStream is, URI docBase, Locale locale) throws IOException {
        if (is == null || locale == null) {
            throw new IllegalArgumentException();
        }
        Document doc = XMLUtilities.loadDocument(is);
        CharacterData characterData = new CharacterData();
        characterData.setDocBase(docBase);
        try {
            void var19_35;
            Element docElm = doc.getDocumentElement();
            if (!"character".equals(docElm.getNodeName())) {
                throw new IOException("Invalid Format.");
            }
            String ns = docElm.getNamespaceURI();
            if (ns == null || !ns.startsWith("http://charactermanaj.sourceforge.jp/schema/charactermanaj")) {
                throw new IOException("unsupported xml format");
            }
            String docVersion = docElm.getAttribute("version").trim();
            if (!"1.0".equals(docVersion)) {
                throw new IOException("unsupported version: " + docVersion);
            }
            String characterId = docElm.getAttribute("id").trim();
            String characterRev = docElm.getAttribute("rev").trim();
            characterData.setId(characterId);
            characterData.setRev(characterRev);
            String lang = locale.getLanguage();
            String characterName = XMLUtilities.getLocalizedElementText(docElm, "name", lang);
            if (characterName == null) {
                characterName = "default";
            }
            characterData.setName(characterName.trim());
            String author = null;
            String description = null;
            for (Element infoElm : XMLUtilities.getChildElements(docElm, "information")) {
                if (author == null) {
                    author = XMLUtilities.getLocalizedElementText(infoElm, "author", lang);
                }
                if (description != null) continue;
                description = XMLUtilities.getLocalizedElementText(infoElm, "description", lang);
            }
            if (author == null) {
                author = "";
            }
            characterData.setAuthor(author.trim());
            if (description == null) {
                description = null;
            }
            characterData.setDescription(description);
            int width = 0;
            int height = 0;
            Iterator<Element> iterator = XMLUtilities.getChildElements(docElm, "image-size").iterator();
            if (iterator.hasNext()) {
                String string;
                Element element = iterator.next();
                String string2 = XMLUtilities.getLocalizedElementText(element, "width", lang);
                if (string2 != null && string2.trim().length() > 0) {
                    width = Integer.parseInt(string2.trim());
                }
                if ((string = XMLUtilities.getLocalizedElementText(element, "height", lang)) != null && string.trim().length() > 0) {
                    height = Integer.parseInt(string.trim());
                }
            }
            if (width <= 0) {
                width = 300;
            }
            if (height <= 0) {
                height = 400;
            }
            characterData.setImageSize(new Dimension(width, height));
            for (Element element : XMLUtilities.getChildElements(docElm, "settings")) {
                for (Element element2 : XMLUtilities.getChildElements(element, "entry")) {
                    String string = element2.getAttribute("key").trim();
                    String val = element2.getTextContent();
                    characterData.setProperty(string, val);
                }
            }
            ArrayList<ColorGroup> colorGroups = new ArrayList<ColorGroup>();
            for (Element element : XMLUtilities.getChildElements(docElm, "colorGroups")) {
                for (Element element3 : XMLUtilities.getChildElements(element, "colorGroup")) {
                    String colorGroupId = element3.getAttribute("id").trim();
                    String colorGroupDisplayName = XMLUtilities.getLocalizedElementText(element3, "display-name", lang);
                    ColorGroup colorGroup = new ColorGroup(colorGroupId, colorGroupDisplayName);
                    colorGroups.add(colorGroup);
                }
            }
            characterData.setColorGroups(colorGroups);
            ArrayList<PartsCategory> arrayList = new ArrayList<PartsCategory>();
            for (Element element : XMLUtilities.getChildElements(docElm, "categories")) {
                for (Element catElm : XMLUtilities.getChildElements(element, "category")) {
                    String categoryId = catElm.getAttribute("id").trim();
                    boolean multipleSelectable = Boolean.parseBoolean(catElm.getAttribute("multipleSelectable"));
                    String categoryDisplayName = XMLUtilities.getLocalizedElementText(catElm, "display-name", lang);
                    int visibleRows = 0;
                    String tmpVisibleRows = XMLUtilities.getLocalizedElementText(catElm, "visible-rows", lang);
                    if (tmpVisibleRows != null && tmpVisibleRows.trim().length() > 0) {
                        visibleRows = Integer.parseInt(tmpVisibleRows.trim());
                    }
                    if (visibleRows <= 0) {
                        visibleRows = 0;
                    }
                    ArrayList<Layer> layers = new ArrayList<Layer>();
                    for (Element layersElm : XMLUtilities.getChildElements(catElm, "layers")) {
                        for (Element layerElm : XMLUtilities.getChildElements(layersElm, "layer")) {
                            String layerDir;
                            String layerId = layerElm.getAttribute("id");
                            String layerDisplayName = XMLUtilities.getLocalizedElementText(layerElm, "display-name", lang);
                            String strOrder = XMLUtilities.getElementText(layerElm, "order");
                            int order = layers.size();
                            if (strOrder != null && strOrder.trim().length() > 0) {
                                order = Integer.parseInt(strOrder.trim());
                            }
                            if ((layerDir = XMLUtilities.getElementText(layerElm, "dir")) == null || layerDir.trim().length() == 0) {
                                throw new IOException("layer's dir is null");
                            }
                            String colorModelName = XMLUtilities.getElementText(layerElm, "colorModel");
                            if (colorModelName == null || colorModelName.length() == 0) {
                                colorModelName = ColorModels.DEFAULT.name();
                            }
                            boolean initSync = false;
                            ColorGroup colorGroup = null;
                            Element lcgElm = XMLUtilities.getFirstChildElement(layerElm, "colorGroup");
                            if (lcgElm != null) {
                                String tmpInitSync = lcgElm.getAttribute("init-sync");
                                if (tmpInitSync.trim().length() > 0) {
                                    initSync = Boolean.parseBoolean(tmpInitSync.trim());
                                }
                                if (colorGroup == null) {
                                    String colorGroupRefId = lcgElm.getAttribute("refid").trim();
                                    colorGroup = characterData.getColorGroup(colorGroupRefId);
                                }
                            }
                            Layer layer = new Layer(layerId, layerDisplayName, order, colorGroup, initSync, layerDir, colorModelName);
                            layers.add(layer);
                        }
                    }
                    PartsCategory category = new PartsCategory(arrayList.size(), categoryId, categoryDisplayName, multipleSelectable, visibleRows, layers.toArray(new Layer[layers.size()]));
                    arrayList.add(category);
                }
            }
            characterData.setPartsCategories(arrayList.toArray(new PartsCategory[arrayList.size()]));
            for (Element element : XMLUtilities.getChildElements(docElm, "presets")) {
                this.loadPartsSet(characterData, element, true, lang);
            }
            Object var19_34 = null;
            for (Element element : XMLUtilities.getChildElements(docElm, "recommendations")) {
                for (Element recmElm : XMLUtilities.getChildElements(element, "recommendation")) {
                    String recommentDescription = XMLUtilities.getLocalizedElementText(recmElm, "description", lang);
                    String url = XMLUtilities.getLocalizedElementText(recmElm, "URL", lang);
                    if (recommentDescription != null) {
                        recommentDescription = recommentDescription.trim();
                    }
                    if (url != null) {
                        url = url.trim();
                    }
                    RecommendationURL recommendationURL = new RecommendationURL();
                    recommendationURL.setDisplayName(recommentDescription);
                    recommendationURL.setUrl(url);
                    if (var19_35 == null) {
                        ArrayList arrayList2 = new ArrayList();
                    }
                    var19_35.add(recommendationURL);
                }
            }
            characterData.setRecommendationURLList((List<RecommendationURL>)var19_35);
        }
        catch (RuntimeException ex) {
            IOException ex2 = new IOException("CharacterData invalid format.");
            ex2.initCause(ex);
            throw ex2;
        }
        return characterData;
    }

    public void loadPartsSet(CharacterData characterData, InputStream inpstm) throws IOException {
        if (characterData == null || inpstm == null) {
            throw new IllegalArgumentException();
        }
        Document doc = XMLUtilities.loadDocument(inpstm);
        Element docElm = doc.getDocumentElement();
        if (!"partssets".equals(docElm.getNodeName())) {
            logger.log(Level.WARNING, "invalid partsets format.");
            return;
        }
        String ns = docElm.getNamespaceURI();
        if (ns == null || !ns.startsWith("http://charactermanaj.sourceforge.jp/schema/charactermanaj")) {
            logger.log(Level.WARNING, "invalid partsets format.");
            return;
        }
        String lang = Locale.getDefault().getLanguage();
        this.loadPartsSet(characterData, docElm, false, lang);
    }

    protected void loadPartsSet(CharacterData characterData, Element nodePartssets, boolean presetParts, String lang) {
        IndependentPartsSetInfoList partsSetLst = this.loadPartsSetList(nodePartssets, lang);
        logger.info("partsSetList: size=" + partsSetLst.size());
        if (presetParts) {
            characterData.setDefaultPartsSetId(partsSetLst.getDefaultPresetId());
        }
        for (IndependentPartsSetInfo partsSetInfo : partsSetLst) {
            PartsSet partsSet = IndependentPartsSetInfo.convertPartsSet(partsSetInfo, characterData, presetParts);
            characterData.addPartsSet(partsSet);
        }
    }

    public IndependentPartsSetInfoList loadPartsSetList(Element nodePartssets, String lang) {
        if (nodePartssets == null || lang == null || lang.length() == 0) {
            throw new IllegalArgumentException();
        }
        IndependentPartsSetInfoList partsSetLst = new IndependentPartsSetInfoList();
        String defaultPresetId = nodePartssets.getAttribute("default-preset");
        if (defaultPresetId != null) {
            defaultPresetId = defaultPresetId.trim();
        }
        for (Element presetElm : XMLUtilities.getChildElements(nodePartssets, "preset")) {
            IndependentPartsSetInfo partsSetInfo = this.loadPartsSet(presetElm, lang);
            if (partsSetInfo == null) continue;
            String partsSetId = partsSetInfo.getId();
            if (defaultPresetId == null || defaultPresetId.length() == 0) {
                defaultPresetId = partsSetId;
            }
            partsSetLst.add(partsSetInfo);
        }
        if (defaultPresetId.length() == 0) {
            defaultPresetId = null;
        }
        partsSetLst.setDefaultPresetId(defaultPresetId);
        return partsSetLst;
    }

    public IndependentPartsSetInfo loadPartsSet(Element presetElm, String lang) {
        String tmpAffienTrans;
        if (presetElm == null || lang == null) {
            return null;
        }
        IndependentPartsSetInfo partsSetInfo = new IndependentPartsSetInfo();
        String partsSetId = presetElm.getAttribute("id");
        if (partsSetId != null) {
            partsSetId = partsSetId.trim();
        }
        if (partsSetId != null && partsSetId.length() == 0) {
            partsSetId = null;
        }
        partsSetInfo.setId(partsSetId);
        String displayName = XMLUtilities.getLocalizedElementText(presetElm, "display-name", lang);
        partsSetInfo.setDisplayName(displayName);
        Element bgColorElm = XMLUtilities.getFirstChildElement(presetElm, "background-color");
        if (bgColorElm != null) {
            String tmpBgColor = bgColorElm.getAttribute("color");
            try {
                Color bgColor = Color.decode(tmpBgColor);
                partsSetInfo.setBackgroundColor(bgColor);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "bgColor parameter is invalid. :" + tmpBgColor, ex);
            }
        }
        if ((tmpAffienTrans = XMLUtilities.getElementText(presetElm, "affine-transform-parameter")) != null && tmpAffienTrans.trim().length() > 0) {
            try {
                ArrayList<Double> affineTransformParameterArr = new ArrayList<Double>();
                for (String strParam : tmpAffienTrans.split("\\s+")) {
                    affineTransformParameterArr.add(Double.valueOf(strParam));
                }
                double[] affineTransformParameter = new double[affineTransformParameterArr.size()];
                int idx = 0;
                Iterator iterator = affineTransformParameterArr.iterator();
                while (iterator.hasNext()) {
                    double aaffineItem = (Double)iterator.next();
                    affineTransformParameter[idx++] = aaffineItem;
                }
                partsSetInfo.setAffineTransformParameter(affineTransformParameter);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "affine transform parameter is invalid. :" + tmpAffienTrans, ex);
            }
        }
        Map<String, Map<String, List<IndependentPartsColorInfo>>> partsMap = partsSetInfo.getPartsMap();
        for (Element catElm : XMLUtilities.getChildElements(presetElm, "category")) {
            String categoryId = catElm.getAttribute("refid");
            if (categoryId != null) {
                categoryId = categoryId.trim();
            }
            if (categoryId == null || categoryId.length() == 0) {
                logger.log(Level.WARNING, "missing category refid: " + catElm);
                continue;
            }
            Map<String, List<IndependentPartsColorInfo>> categoryPartsMap = partsMap.get(categoryId);
            if (categoryPartsMap == null) {
                categoryPartsMap = new HashMap<String, List<IndependentPartsColorInfo>>();
                partsMap.put(categoryId, categoryPartsMap);
            }
            for (Element partsElm : XMLUtilities.getChildElements(catElm, "parts")) {
                String partsName = partsElm.getAttribute("name");
                if (partsName != null) {
                    partsName = partsName.trim();
                }
                if (partsName == null || partsName.length() == 0) {
                    logger.log(Level.WARNING, "missing parts name. " + partsElm);
                    continue;
                }
                List<IndependentPartsColorInfo> infoList = null;
                Iterator<Element> iterator = XMLUtilities.getChildElements(partsElm, "color").iterator();
                if (iterator.hasNext()) {
                    Element colorElm = iterator.next();
                    infoList = this.readPartsColor(colorElm);
                }
                categoryPartsMap.put(partsName, infoList);
            }
        }
        return partsSetInfo;
    }

    public List<IndependentPartsColorInfo> readPartsColor(Element colorElm) {
        if (colorElm == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndependentPartsColorInfo> infoList = new ArrayList<IndependentPartsColorInfo>();
        for (Element layerElm : XMLUtilities.getChildElements(colorElm, "layer")) {
            Element elmRgbReplace;
            Element elmHsb;
            IndependentPartsColorInfo info = new IndependentPartsColorInfo();
            String layerId = layerElm.getAttribute("refid");
            if (layerId != null) {
                layerId = layerId.trim();
            }
            if (layerId == null || layerId.length() == 0) {
                logger.log(Level.WARNING, "missing layer-id: " + layerElm);
                continue;
            }
            info.setLayerId(layerId);
            Element colorGroupElm = XMLUtilities.getFirstChildElement(layerElm, "color-group");
            if (colorGroupElm != null) {
                String colorGroupId = colorGroupElm.getAttribute("group").trim();
                info.setColorGroupId(colorGroupId);
                boolean syncColorGroup = Boolean.parseBoolean(colorGroupElm.getAttribute("synchronized").trim());
                info.setSyncColorGroup(syncColorGroup);
            }
            ColorConvertParameter param = info.getColorConvertParameter();
            Element nodeRgb = XMLUtilities.getFirstChildElement(layerElm, "rgb");
            if (nodeRgb != null) {
                for (Element elmRgb : XMLUtilities.getChildElements(nodeRgb, null)) {
                    String rgbName = elmRgb.getNodeName();
                    int offset = Integer.parseInt(elmRgb.getAttribute("offset"));
                    float factor = Float.parseFloat(elmRgb.getAttribute("factor"));
                    float gamma = Float.parseFloat(elmRgb.getAttribute("gamma"));
                    if ("red".equals(rgbName)) {
                        param.setOffsetR(offset);
                        param.setFactorR(factor);
                        param.setGammaR(gamma);
                        continue;
                    }
                    if ("green".equals(rgbName)) {
                        param.setOffsetG(offset);
                        param.setFactorG(factor);
                        param.setGammaG(gamma);
                        continue;
                    }
                    if ("blue".equals(rgbName)) {
                        param.setOffsetB(offset);
                        param.setFactorB(factor);
                        param.setGammaB(gamma);
                        continue;
                    }
                    if (!"alpha".equals(rgbName)) continue;
                    param.setOffsetA(offset);
                    param.setFactorA(factor);
                    param.setGammaA(gamma);
                }
            }
            if ((elmHsb = XMLUtilities.getFirstChildElement(layerElm, "hsb")) != null) {
                float hue = Float.parseFloat(elmHsb.getAttribute("hue"));
                float saturation = Float.parseFloat(elmHsb.getAttribute("saturation"));
                float brightness = Float.parseFloat(elmHsb.getAttribute("brightness"));
                String strContrast = elmHsb.getAttribute("contrast").trim();
                param.setHue(hue);
                param.setSaturation(saturation);
                param.setBrightness(brightness);
                if (strContrast != null && strContrast.length() > 0) {
                    float contrast = Float.parseFloat(strContrast);
                    param.setContrast(contrast);
                }
            }
            if ((elmRgbReplace = XMLUtilities.getFirstChildElement(layerElm, "rgb-replace")) != null) {
                Float grayLevel = Float.valueOf(Float.parseFloat(elmRgbReplace.getAttribute("gray")));
                ColorConv colorType = ColorConv.valueOf(elmRgbReplace.getAttribute("replace-type"));
                param.setGrayLevel(grayLevel.floatValue());
                param.setColorReplace(colorType);
            }
            infoList.add(info);
        }
        return infoList;
    }
}

