/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;

public final class LoadedImage {
    private final BufferedImage image;
    private final long lastModified;
    private final int imageSize;

    public LoadedImage(BufferedImage image, long lastModified) {
        this.image = image;
        this.lastModified = lastModified;
        this.imageSize = LoadedImage.getBufferSize(image);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    private static int getBufferSize(BufferedImage image) {
        if (image == null) {
            return 0;
        }
        DataBuffer buff = image.getRaster().getDataBuffer();
        int bytes = buff.getSize() * DataBuffer.getDataTypeSize(buff.getDataType()) / 8;
        return bytes;
    }
}

