<?php
/**
 * 指定したURLの内容を現在の出力ストリームにそのまま出力する.
 * URLに対するサーバーからのコンテンツタイプの設定が返されない場合はapplication/octet-streamとする。
 * 指定したURLがエラーコードを返した場合は、そのエラーコードを返す.
 * @param $url ダウンロード先URL
 */
function download_direct_url($url)
{
    $curl = curl_init();
    if ($curl === false) {
        header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
        exit;
    }
    
    curl_setopt($curl, CURLOPT_URL, $url);
    
    // wget, curl, poweshellのagent以外からだとダウンロードページを表示するサービス対策
    curl_setopt($curl, CURLOPT_HTTPHEADER, [
        'User-Agent: Wget/1.16 (linux-gnu)'
    ]);
    
    // リダイレクトの有効化、回数制限、リファラの自動設定
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
    curl_setopt($curl, CURLOPT_AUTOREFERER, true);
    
    // SSL対応
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    
    // HEAD取得
    curl_setopt($curl, CURLOPT_NOBODY, true);
    $res = curl_exec($curl);
    
    // 結果コード取得
    $code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    if ($code >= 200 && $code < 300) {
        // コンテントタイプの設定 (なければapplication/octet-stream扱いとする)
        $contentType = curl_getinfo($curl, CURLINFO_CONTENT_TYPE);
        if ($contentType == null) {
            $contentType = 'application/octet-stream';
        }
        header('Content-Type: ' . $contentType);
    
        // ファイル名付与
        $urlinfo = parse_url($url);
        if ($urlinfo !== false) {
            $fname = basename($urlinfo['path']);
            header('Content-Disposition: attachment; filename="' . $fname . '"');
        }
    
        // コンテンツの長さの設定、なければ何もしない
        $len = curl_Getinfo($curl, CURLINFO_CONTENT_LENGTH_DOWNLOAD);
        if ($len !== false && $len > 0) {
            header('Content-Length: ' . $len);
        }

        // GETアクセスして結果を転送する
        curl_setopt($curl, CURLOPT_NOBODY, false);
        curl_exec($curl);
    } else {
        // サーバーステータスコードを、そのまま返す
        header('HTTP', true, $code);
        echo 'ERROR ', $code, PHP_EOL;
    }
    
    curl_close($curl);
}
