// 2018/6時点のIE11を想定しているのでES6のうちconst, letぐらいしか使わない

const MAX_UPLOAD_SIZE = 4 * 1024 * 1024; // 4MB
const MAX_COMMENT_SIZE = 3000; // 3000文字

function escapeHTML(str) {
    "use strict";
    if (str) {
        return str.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
    }
    return '';
}

// https://ja.stackoverflow.com/questions/2582/
function commafy(n) {
    "use strict";
    if (n) {
        let parts = n.toString().split('.');
        parts[0] = parts[0].replace(/(\d)(?=(\d\d\d)+(?!\d))/g, '$1,');
        return parts.join('.');
    }
    return '';
}

function get_display_license(lic) {
    "use strict";
    switch (lic) {
        case '0': return '商用可・改変可・再頒布可';
        case '1': return '商用可・改変不可・再頒布可';
        case '2': return '商用不可・改変可・再頒布可';
        case '3': return '商用不可・改変不可・再頒布可';
    }
    return lic;
}

function reportForm(form) {
    "use strict";
    try {
        $.messager.confirm({
            title: '通報の確認',
            msg: 'このIPアドレスからは、ただちにファイルにアクセスできなくなります。取り消しはできません。',
            fn: function (r) {
                if (r) {
                    let formData = new FormData(form);
                    $.ajax({
                        url: '/cgi-bin/report.php',
                        data: formData,
                        type: 'POST',
                        dataType: 'json', // レスポンスをJSONとして解析
                        processData: false, // Ajaxがdataを整形しない指定
                        contentType: false // マルチパート送信のおまじない
                    }).done(function (res) {
                        if (res.result == 'ok') {
                            $('#zip_comment_area').text('');
                            $('#filetable').datagrid('reload');
                            $('#taglist').datagrid('reload');
                            $.messager.alert('完了', '通報しました', 'info', function () {
                                form.reset();
                                $('#reportDlg').dialog('close');
                            });
                        } else {
                            $.messager.alert('通報に失敗', '通報できませんでした。\n' + res.message, 'error');
                        }

                    }).fail(function (jqXHR, textStatus, errorThrown) {
                        alert('通報に失敗しました。:' + textStatus + ":" + errorThrown);
                    });
                }
            }
        });

    } catch (e) {
        alert(e);
    }
    return false;
}

function uploadForm(form) {
    "use strict";
    try {
        let comment = form['comment'];
        let title = form['title'];
        if (comment.value.length > MAX_COMMENT_SIZE || title.value.length > MAX_COMMENT_SIZE) {
            $.messager.alert('アップロードに失敗',
                'コメントまたはタイトルが長すぎます。\nlimit ' + MAX_COMMENT_SIZE + 'bytes', 'error');
            return false;
        }

        let author = form['author'].value;
        let delkey = form['delkey'].value;
        let license = form['license'].value;
        if (author.length > 100 || delkey.length > 100) {
            $.messager.alert('アップロードに失敗', '入力テキストが長すぎます', 'error');
            return false;
        }

        // authorとdelkeyはブラウザのローカルストレージに記憶しておく
        localStorage.setItem('uploadForm.author', author);
        localStorage.setItem('uploadForm.delkey', delkey);
        localStorage.setItem('uploadForm.license', license);

        let file = form['file'];
        if (file && file.files.length == 1) {
            if (file.files[0].size > MAX_UPLOAD_SIZE) {
                $.messager.alert('アップロードに失敗',
                    'ファイルが大きすぎます。\nlimit ' + MAX_UPLOAD_SIZE + 'bytes', 'error');
                return false;
            }
            let fname = file.files[0].name;
            let pos = fname.lastIndexOf('.');
            let ext = '';
            if (pos > 0) {
                ext = fname.substring(pos + 1).toLowerCase();
            }
            if (ext != 'zip' && ext != 'cmj') {
                $.messager.alert('アップロードに失敗',
                    'zipファイルのみアップロードできます。', 'error');
                return false;
            }

            let formData = new FormData(form);
            $.ajax({
                url: '/cgi-bin/upload.php',
                data: formData,
                type: 'POST',
                dataType: 'json', // レスポンスをJSONとして解析
                processData: false, // Ajaxがdataを整形しない指定
                contentType: false // マルチパート送信のおまじない
            }).done(function (res) {
                if (res.result == 'ok') {
                    $('#filetable').datagrid('reload');
                    $('#taglist').datagrid('reload');
                    $.messager.alert('アップロード完了', 'アップロードしました', 'info', function () {
                        form['file'].value = '';
                        form['title'].value = '';
                    });
                } else {
                    let msg = res.message; 
                    if (res.error_files && res.error_files.length > 0) {
                        msg += '<div><ul>';
                        $.each(res.error_files, function (idx, err_file_name) {
                            msg += '<li>' + escapeHTML(err_file_name) + '</li>';
                        });
                        msg += '</ul></div>';
                    }
                    $.messager.alert('アップロードに失敗', 'アップロードできません。<br>' + msg, 'error');
                }

            }).fail(function (jqXHR, textStatus, errorThrown) {
                alert('アップロードに失敗しました。:' + textStatus + ":" + errorThrown);
            });
        }

    } catch (e) {
        alert(e);
    }
    return false;
};

function deleteForm(form) {
    "use strict";
    try {
        let formData = new FormData(form);
        $.ajax({
            url: '/cgi-bin/delete.php',
            data: formData,
            type: 'POST',
            dataType: 'json', // レスポンスをJSONとして解析
            // Ajaxがdataを整形しない指定
            processData: false,
            // contentTypeもfalseに指定
            contentType: false

        }).done(function (res) {
            if (res.result == 'ok') {
                $('#filetable').datagrid('reload');
                $('#taglist').datagrid('reload');
                $.messager.alert('削除完了', '削除しました', 'info', function () {
                    form.reset();
                    $('#delDlg').dialog('close');
                });
            } else {
                $.messager.alert('削除に失敗', '削除できません。\n' + res.message, 'error');
            }

        }).fail(function (jqXHR, textStatus, errorThrown) {
            alert('削除に失敗しました。:' + textStatus + ":" + errorThrown);
        });

    } catch (e) {
        alert(e);
    }
    return false;
};

function formatTitle(val, row, idx) {
    "use strict";
    return '<a href="#" class="easyui-tooltip" title="File ID: ' + row['id'] +
        '" onclick="clickTitle(' + row['id'] + ',' + idx + ')">' + escapeHTML(val) + '</a>';
}

function clickTitle(id, idx) {
    "use strict";
    let data = $('#filetable').datagrid('getData');
    if (!data || !data.rows) {
        return false;
    }
    try {
        let row = data.rows[idx];
        let datafile = row['fname'];
        let pos = datafile.lastIndexOf('.');
        let ext = (pos > 0) ? datafile.substring(pos) : '.zip';
        let filename = row['title'] + ext;

        // https://qiita.com/tom_konda/items/484955b8332e0305ebc4
        let xhr = new XMLHttpRequest();
        xhr.open('GET', '/cgi-bin/download.php?id=' + id, true);
        xhr.responseType = 'blob';
        xhr.onload = function (oEvent) {
            let blob = xhr.response;
            if (blob) {
                // https://gist.github.com/wemersonjanuario/45d302337b45d6aad866051f0473c646
                if (navigator.appVersion.toString().indexOf('.NET') > 0) {
                    //IE 10+
                    window.navigator.msSaveBlob(blob, filename);
                } else {
                    //Firefox, Chrome
                    let a = document.createElement("a");
                    let blobUrl = window.URL.createObjectURL(new Blob([blob], { type: blob.type }));
                    document.body.appendChild(a);
                    a.style = "display: none";
                    a.href = blobUrl;
                    a.download = filename;
                    a.click();
                }
            }
            $('#filetable').datagrid('reload');
        };
        xhr.send();
        return false;

    } catch (e) {
        alert(e);
        return false;
    }
}

$(function () {
    "use strict";

    var currentZipId = null;
    let onSelectZipHandler = function (rowIndex, rowData) {
        // 選択されたzipの情報を右ペインに表示するためのajax
        $('#zip_comment_area').text(''); // ajax完了までは空白にしておく
        let zipid = rowData['id'];
        currentZipId = zipid;
        $.ajax({
            url: '/cgi-bin/zipinfo.php',
            data: {
                'zipid': zipid,
                'contentsTypes': ['tag', 'parts', 'comment'],
                'time': new Date().getTime()
            },
            type: 'GET',
            dataType: 'json', // レスポンスをJSONとして解析
        }).done(function (res) {
            if (zipid === currentZipId) {
                // ajax要求時点とzipidが歩変更なければ画面を更新する
                // (変更があれば、このレスポンスは捨てる)
                let msg = '';
                if (res.tags && res.tags.length > 0) {
                    msg += '<b>[タグ]</b>\r\n';
                    $.each(res.tags, function (idx, tag) {
                        msg += escapeHTML(tag) + '\r\n';
                    });
                    msg += '\r\n';
                }
                if (res.partsnames && res.partsnames.length > 0) {
                    msg += '<b>[パーツ一覧]</b>\r\n';
                    $.each(res.partsnames, function (idx, partsname) {
                        msg += escapeHTML(partsname) + '\r\n';
                    });
                    msg += '\r\n';
                }
                if (res.comment) {
                    msg += '<b>[コメント]</b>\r\n';
                    msg += escapeHTML(res.comment) + '\r\n';
                }
                $('#zip_comment_area').html(msg);
            }

        }).fail(function (jqXHR, textStatus, errorThrown) {
            $('#zip_comment_area').text(textStatus + ":" + errorThrown);
        });
    };

    var currentPartsZipId = null;
    let onSelectPartsZipHandler = function (rowIndex, rowData) {
        // 選択されたzipの情報を右ペインに表示するためのajax
        $('#zip_comment_area').text(''); // ajax完了までは空白にしておく
        let zipid = rowData['id'];
        if (currentPartsZipId != zipid) {
            currentPartsZipId = zipid;
            $.ajax({
                url: '/cgi-bin/zipinfo.php',
                data: {
                    'zipid': zipid,
                    'contentsTypes': ['comment'],
                    'time': new Date().getTime()
                },
                type: 'GET',
                dataType: 'json', // レスポンスをJSONとして解析
            }).done(function (res) {
                if (zipid === currentPartsZipId) {
                    // ajax要求時点とzipidが歩変更なければ画面を更新する
                    // (変更があれば、このレスポンスは捨てる)
                    var msg = '';
                    if (res.comment) {
                        msg += escapeHTML(res.comment) + '\r\n';
                    }
                    $('#parts_comment_area').html(msg);
                }
            }).fail(function (jqXHR, textStatus, errorThrown) {
                $('#parts_comment_area').text(textStatus + ":" + errorThrown);
            });
        }
    };

    let checked_tagids = {};
    var request_search_parts = false;
    let search_parts = function () {
        if (!request_search_parts) {
            return;
        }
        request_search_parts = false;
        $('#partslist').datagrid('reload');
    };

    $('#taglist').datagrid({
        pagination: true,
        url: '/cgi-bin/taglist.php',
        method: 'get',
        remoteSort: true,
        queryParams: {
            tzoffset: -(new Date().getTimezoneOffset()), // GMTとの差
            time: new Date().getTime()
        },
        toolbar: [{
            text: 'リセット',
            iconCls: 'icon-cancel',
            handler: function () {
                $('#taglist').datagrid('clearChecked');
                Object.keys(checked_tagids).forEach(function (prop) {
                    delete checked_tagids[prop];
                });
                request_search_parts = true;
                setTimeout(search_parts, 1);
            }
        }],
        onLoadSuccess: function () {
            let rows = $(this).datagrid('getRows');
            for (var i = 0; i < rows.length; i++) {
                let tagid = rows[i].id;
                if (checked_tagids[tagid]) {
                    $(this).datagrid('checkRow', i);
                }
            }
        },
        onSelect: function (rowIndex, rowData) {
            let tagid = rowData.id;
            checked_tagids[tagid] = true;
            request_search_parts = true;
            setTimeout(search_parts, 1);
        },
        onUnselect: function (rowIndex, rowData) {
            let tagid = rowData.id;
            checked_tagids[tagid] = false;
            request_search_parts = true;
            setTimeout(search_parts, 1);
        },
        onSelectAll: function () {
            let rows = $(this).datagrid('getRows');
            for (var i = 0; i < rows.length; i++) {
                let tagid = rows[i].id;
                checked_tagids[tagid] = true;
            }
            request_search_parts = true;
            setTimeout(search_parts, 1);
        },
        onUnselectAll: function () {
            let rows = $(this).datagrid('getRows');
            for (var i = 0; i < rows.length; i++) {
                let tagid = rows[i].id;
                checked_tagids[tagid] = false;
            }
            request_search_parts = true;
            setTimeout(search_parts, 1);
        },
        pageList: [30, 60, 90, 120]
    });

    // ログイン済みクッキーがあるか？ (有効かは問わない。表示切り替えのみ)
    let hasCmjSid = document.cookie.indexOf('cmj-uploader-sid=') >= 0;

    let doLogin = function () {
        $.messager.confirm('ログイン',
            'OSDNユーザとしてログインすることでアップロード制限を解除できます',
            function (r) {
                if (r) {
                    let url = 'https://osdn.net/account/oauth2ui/authorize?' +
                        'client_id=c10e635f25f1875ac9add68528a735d49dbd110ae15fe1e7b4d01eccc47db591&' +
                        'response_type=code&' +
                        'scope=profile&' +
                        'state=' + window.location.hostname;
                    window.location = url;
                }
            });
    };

    // ログインキー(Cookie)の表示
    let showLogin = function () {
        var cookies = document.cookie;
        var result = [];
        if (cookies != '') {
            var cookieArray = cookies.split(';');
            for (var i = 0; i < cookieArray.length; i++) {
                var cookie = cookieArray[i].split('=');
                result[cookie[0]] = decodeURIComponent(cookie[1]);
            }
        }
        if (result['cmj-uploader-sid']) {
            $('#txtSid').val(result['cmj-uploader-sid']);
            $('#showSidDlg').dialog('open');
        }
    };

    // ZIPファイル一覧用データグリッド
    $('#filetable').datagrid({
        pagination: true,
        url: '/cgi-bin/ziplist.php',
        method: 'get',
        remoteSort: true,
        toolbar: [{
            text: 'アップロードする',
            iconCls: 'icon-add',
            handler: function () {
                $('#upDlg').dialog('open');
            }
        }, '-', {
            text: '削除する',
            iconCls: 'icon-remove',
            handler: function () {
                let row = $('#filetable').datagrid('getSelected');
                if (row) {
                    $('input[name="selected_id"]').val(row['id']);
                    $('#delDlg').dialog('open');
                }
            }
        }, {
            text: '通報する',
            iconCls: 'icon-cancel',
            handler: function () {
                let row = $('#filetable').datagrid('getSelected');
                if (row) {
                    $('input[name="selected_id"]').val(row['id']);
                    $('#report_zip_title').text(row['title']);
                    $('#reportDlg').dialog('open');
                }
            }
        }, {
            text: (hasCmjSid ? 'ログイン中(キーの表示)' : 'アップロード制限の解除'),
            iconCls: 'icon-edit',
            handler: hasCmjSid ? showLogin : doLogin
        }],
        queryParams: {
            tzoffset: -(new Date().getTimezoneOffset()), // GMTとの差
            time: new Date().getTime()
        },
        onSelect: onSelectZipHandler,
        pageList: [30, 60, 90, 120]
    });

    // パーツファイル一覧用データグリッド
    $('#partslist').datagrid({
        pagination: true,
        url: '/cgi-bin/partslist.php',
        method: 'post',
        remoteSort: true,
        queryParams: {
            tzoffset: -(new Date().getTimezoneOffset()), // GMTとの差
            time: new Date().getTime()
        },
        onBeforeLoad: function (param) {
            var tagids = [];
            Object.keys(checked_tagids).forEach(function (key) {
                if (checked_tagids[key]) {
                    tagids.push(key);
                }
            });
            param.tagids = tagids;
        },
        onSelect: onSelectPartsZipHandler,
        onLoadSuccess: function () {
            currentPartsZipId = null;
            $('#parts_comment_area').html('');
        },
        pageList: [30, 60, 90, 120]
    });

    // ファィルを選択したときにタイトルをファイル名から設定する
    $('input[name="file"]').on('change', function () {
        if (this.files.length > 0) {
            let fname = this.files[0].name;
            // 拡張子を除去する
            let pos = fname.lastIndexOf('.');
            if (pos > 0) {
                fname = fname.substring(0, pos);
            }
            // ファイル名に$があれば削除キーとして使用する
            pos = fname.lastIndexOf('$');
            if (pos > 0) {
                let delkey = fname.substring(pos + 1);
                fname = fname.substring(0, pos);
                $('input[name="delkey"').val(delkey);
            }
            // ファイル名に@があれば作者名として使用する
            pos = fname.lastIndexOf('@');
            if (pos > 0) {
                let author = fname.substring(pos + 1);
                fname = fname.substring(0, pos);
                $('input[name="author"]').val(author);
            }
            // タイトルの設定
            $('input[name="title"]').val(fname);
        }
    });

    // 削除キーのリセット処理
    let $form = $('form');
    $form.on('reset', function () {
        setTimeout(function () {
            // delkeyが空欄であればランダムの割り当て
            if ($('input[name="delkey"]').val() == '') {
                let autoDelKey = Math.floor(Math.random() * 65535).toString(16);
                $('input[name="delkey"]').val(autoDelKey);
            }
        }, 1);
    });
    $form[0].reset();

    // 削除ダイアログの入力項目の活性制御
    $('input[name="keytype"]:radio').on('change', function () {
        let val = $(this).val();
        if (val == 'TRIP') {
            $('input[name="verifydelkey"]').attr('disabled', 'disabled');
            $('input[name="verifytrip"]').removeAttr('disabled');
        } else {
            $('input[name="verifydelkey"]').removeAttr('disabled');
            $('input[name="verifytrip"]').attr('disabled', 'disabled');
        }
    });

    // ローカルストレージに記憶されているauthorとdelkeyを復元する
    if (localStorage['uploadForm.author']) {
        $('input[name="author"]').val(localStorage['uploadForm.author']);
    }
    if (localStorage['uploadForm.delkey']) {
        $('input[name="delkey"]').val(localStorage['uploadForm.delkey']);
    }
    if (localStorage['uploadForm.license']) {
        $('select[name="license"]').val(localStorage['uploadForm.license']);
    }
});
