/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageLoader;
import charactermanaj.graphics.colormodel.ColorModel;
import charactermanaj.graphics.colormodel.ColorModels;
import charactermanaj.graphics.filters.ColorConvertFilter;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.filters.ContrastTableFactory;
import charactermanaj.graphics.filters.GammaTableFactory;
import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.LoadedImage;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;

public class ColorConvertedImageLoaderImpl
implements ColorConvertedImageLoader {
    private static final ColorConvertParameter NULL_COLORCONVPARAM = new ColorConvertParameter();
    private ImageLoader loader;

    public ColorConvertedImageLoaderImpl(ImageLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException();
        }
        this.loader = loader;
    }

    public LoadedImage load(ImageResource file, ColorConvertParameter colorConvParam, ColorModel colorModel) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (colorConvParam == null) {
            colorConvParam = NULL_COLORCONVPARAM;
        }
        if (colorModel == null) {
            colorModel = ColorModels.DEFAULT;
        }
        LoadedImage loadedImage = this.loader.load(file);
        BufferedImage originalImage = loadedImage.getImage();
        BufferedImage image = this.colorConvert(originalImage, colorConvParam, colorModel);
        return new LoadedImage(image, loadedImage.getLastModified());
    }

    private BufferedImage colorConvert(BufferedImage img, ColorConvertParameter param, ColorModel colorModel) {
        float[] factors = new float[]{param.getFactorR(), param.getFactorG(), param.getFactorB(), param.getFactorA()};
        float[] offsets = new float[]{param.getOffsetR(), param.getOffsetG(), param.getOffsetB(), param.getOffsetA()};
        RescaleOp rescale_op = new RescaleOp(factors, offsets, null);
        float[] gammas = new float[]{param.getGammaA(), param.getGammaR(), param.getGammaG(), param.getGammaB()};
        float[] hsbs = new float[]{param.getHue(), param.getSaturation(), param.getBrightness()};
        float contrast = param.getContrast();
        ColorConvertFilter colorConvert_op = new ColorConvertFilter(colorModel, param.getColorReplace(), hsbs, param.getGrayLevel(), new GammaTableFactory(gammas), new ContrastTableFactory((float)Math.exp(contrast * 2.0f)));
        img = colorConvert_op.filter(img, null);
        img = rescale_op.filter(img, img);
        return img;
    }
}

