/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.ColorGroup;
import java.io.File;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Layer
implements Comparable<Layer>,
Serializable {
    private static final long serialVersionUID = -6437516046486547811L;
    private final int order;
    private final String id;
    private final String localizedName;
    private final ColorGroup colorGroup;
    private final boolean initSync;
    private final String dir;

    public Layer(String id, String localizedName, int order, ColorGroup colorGroup, boolean initSync, String dir) {
        if (id == null || id.length() == 0 || order < 0 || dir == null) {
            throw new IllegalArgumentException();
        }
        if (localizedName == null || localizedName.length() == 0) {
            localizedName = id;
        }
        if (colorGroup == null) {
            colorGroup = ColorGroup.NA;
        }
        this.id = id;
        this.localizedName = localizedName;
        this.order = order;
        this.colorGroup = colorGroup;
        this.initSync = initSync;
        this.dir = dir;
    }

    @Override
    public int compareTo(Layer o) {
        int ret = this.order - o.order;
        if (ret == 0) {
            ret = this.id.compareTo(o.id);
        }
        if (ret == 0) {
            File d1 = new File(this.dir);
            File d2 = new File(o.dir);
            ret = d1.compareTo(d2);
        }
        return ret;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public int getOrder() {
        return this.order;
    }

    public ColorGroup getColorGroup() {
        return this.colorGroup;
    }

    public boolean isInitSync() {
        return this.initSync;
    }

    public String getDir() {
        return this.dir;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof Layer) {
            Layer o = (Layer)obj;
            File d1 = new File(this.dir);
            File d2 = new File(o.dir);
            return this.id.equals(o.id) && this.order == o.order && d1.equals(d2);
        }
        return false;
    }

    public static boolean equals(Layer a, Layer b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Layer(id=" + this.id + ", name=" + this.localizedName + ", order=" + this.order + ")";
    }
}

