/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.clipboardSupport;

import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.model.AppConfig;
import java.awt.Color;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageSelection
implements Transferable {
    private static final Logger logger = Logger.getLogger(ImageSelection.class.getName());
    private static final boolean platformWindows;
    private BufferedImage img;
    private Color bgColor;
    private static final DataFlavor PNG_FLAVOR;
    private static final DataFlavor JPEG_FLAVOR;
    private static final DataFlavor BMP_FLAVOR;
    private static final List<DataFlavor> SUPPORTED_FLAVORS;

    public static boolean setupSystemFlavorMap() {
        try {
            FlavorMap defFlavorMap;
            AppConfig appConfig;
            if (platformWindows && (appConfig = AppConfig.getInstance()).isEnablePNGSupportForWindows() && (defFlavorMap = SystemFlavorMap.getDefaultFlavorMap()) instanceof SystemFlavorMap) {
                SystemFlavorMap sysFlavorMap = (SystemFlavorMap)defFlavorMap;
                List<String> natives = sysFlavorMap.getNativesForFlavor(null);
                if (natives.contains("PNG")) {
                    sysFlavorMap.setNativesForFlavor(PNG_FLAVOR, new String[]{"PNG"});
                } else {
                    logger.log(Level.INFO, "PNG flavor is not supported.");
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "systemFlavorMap setup failed.", ex);
            return false;
        }
    }

    public ImageSelection(BufferedImage img, Color bgColor) {
        if (img == null) {
            throw new IllegalArgumentException();
        }
        this.img = img;
        this.bgColor = bgColor == null ? Color.white : bgColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor != null) {
            logger.log(Level.INFO, "getTransferData flavor=" + flavor);
            try {
                ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
                if (flavor.equals(PNG_FLAVOR) || flavor.equals(JPEG_FLAVOR) || flavor.equals(BMP_FLAVOR)) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        imageSaveHelper.savePicture(this.img, this.bgColor, bos, flavor.getMimeType(), null);
                    }
                    finally {
                        bos.close();
                    }
                    return new ByteArrayInputStream(bos.toByteArray());
                }
                if (flavor.equals(DataFlavor.imageFlavor)) {
                    AppConfig appConfig = AppConfig.getInstance();
                    if (platformWindows || !appConfig.isEnablePNGSupportForWindows()) {
                        return imageSaveHelper.createBMPFormatPicture(this.img, this.bgColor);
                    }
                    return this.img;
                }
            }
            catch (RuntimeException ex) {
                logger.log(Level.WARNING, "The exception occurred during the data transfer of a clipboard.", ex);
                throw ex;
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "The exception occurred during the data transfer of a clipboard.", ex);
                throw ex;
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return SUPPORTED_FLAVORS.toArray(new DataFlavor[SUPPORTED_FLAVORS.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor != null && SUPPORTED_FLAVORS.contains(flavor);
    }

    public static boolean isSupprotedFlavorAvailable(Clipboard cb) {
        if (cb != null) {
            for (DataFlavor flavor : SUPPORTED_FLAVORS) {
                if (!cb.isDataFlavorAvailable(flavor)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getImage(Clipboard cb) throws IOException {
        block10: {
            if (cb == null) {
                return null;
            }
            try {
                BufferedImage img;
                InputStream is;
                for (DataFlavor flavor : cb.getAvailableDataFlavors()) {
                    logger.log(Level.INFO, "dataFlavor(in Clipboard)=" + flavor);
                }
                DataFlavor availableFlavor = null;
                for (DataFlavor flavor : SUPPORTED_FLAVORS) {
                    if (!cb.isDataFlavorAvailable(flavor)) continue;
                    availableFlavor = flavor;
                    break;
                }
                logger.log(Level.INFO, "selected flavor=" + availableFlavor);
                if (availableFlavor == null) break block10;
                if (availableFlavor.equals(DataFlavor.imageFlavor)) {
                    return (BufferedImage)cb.getData(DataFlavor.imageFlavor);
                }
                if (!availableFlavor.equals(PNG_FLAVOR) && !availableFlavor.equals(JPEG_FLAVOR) && !availableFlavor.equals(BMP_FLAVOR) || (is = (InputStream)cb.getData(availableFlavor)) == null) break block10;
                try {
                    img = ImageIO.read(is);
                }
                finally {
                    is.close();
                }
                return img;
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "The exception occurred in access to a clipboard.", ex);
                throw ex;
            }
            catch (UnsupportedFlavorException ex) {
                logger.log(Level.WARNING, "The exception occurred in access to a clipboard.", ex);
                throw new IOException(ex.getMessage());
            }
        }
        return null;
    }

    static {
        PNG_FLAVOR = new DataFlavor("image/png", "image/png");
        JPEG_FLAVOR = new DataFlavor("image/jpeg", "image/jpeg");
        BMP_FLAVOR = new DataFlavor("image/bmp", "image/bmp");
        String lcOS = System.getProperty("os.name").toLowerCase();
        platformWindows = lcOS.indexOf("windows") >= 0;
        SUPPORTED_FLAVORS = platformWindows ? Arrays.asList(PNG_FLAVOR, DataFlavor.imageFlavor) : Arrays.asList(PNG_FLAVOR, JPEG_FLAVOR, BMP_FLAVOR, DataFlavor.imageFlavor);
    }
}

