/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj;

import charactermanaj.clipboardSupport.ImageSelection;
import charactermanaj.model.AppConfig;
import charactermanaj.model.util.StartupSupport;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.ui.SelectCharatersDirDialog;
import charactermanaj.util.AWTExceptionLoggingHandler;
import charactermanaj.util.ApplicationLoggerConfigurator;
import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.DirectoryConfig;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.FileNameNormalizer;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public final class Main
implements Runnable {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final boolean isMacOSX;
    private static final boolean isLinux;

    private static void initLogger() {
        try {
            ApplicationLoggerConfigurator.configure();
            System.setProperty("sun.awt.exception.handler", AWTExceptionLoggingHandler.class.getName());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "logger initiation failed. " + ex, ex);
        }
    }

    private static double getJavaVersion() {
        try {
            String version = System.getProperty("java.version");
            String[] versions = version.split("\\.");
            if (versions.length > 2) {
                return Double.valueOf(versions[0] + "." + versions[1]);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return 0.0;
    }

    private static void setupUIManager() throws Exception {
        if (Main.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CharacterManaJ");
            if (Main.getJavaVersion() >= 1.7) {
                FileNameNormalizer.setupNFCNormalizer();
            }
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        Object textFieldFontUI = UIManager.get("TextField.font");
        if (textFieldFontUI == null) {
            textFieldFontUI = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"dialog", 0, 12});
        }
        UIManager.put("TextArea.font", textFieldFontUI);
    }

    public void run() {
        try {
            File defaultCharacterDir;
            File currentCharacterDir;
            try {
                Main.setupUIManager();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.log(Level.WARNING, "UIManager setup failed.", ex);
            }
            AppConfig appConfig = AppConfig.getInstance();
            appConfig.loadConfig();
            if (!ImageSelection.setupSystemFlavorMap()) {
                logger.log(Level.WARNING, "failed to set the clipboard-support.");
            }
            if (Main.isMacOSX() && Main.getJavaVersion() >= 1.7) {
                String lang = System.getenv("LANG");
                String lcctype = System.getenv("LC_CTYPE");
                if (!(lang != null && lang.trim().length() != 0 || lcctype != null && lcctype.trim().length() != 0)) {
                    JOptionPane.showMessageDialog(null, "\"LANG\" environment variable is not set!.", "Configuration Error", 0);
                }
            }
            if ((currentCharacterDir = SelectCharatersDirDialog.getCharacterDir(defaultCharacterDir = ConfigurationDirUtilities.getDefaultCharactersDir())) == null) {
                logger.info("luncher canceled.");
                return;
            }
            DirectoryConfig.getInstance().setCharactersDir(currentCharacterDir);
            StartupSupport.getInstance().doStartup();
            MainFrame mainFrame = ProfileListManager.openDefaultProfile();
            if (Main.isMacOSX()) {
                try {
                    Class<?> clz = Class.forName("charactermanaj.ui.MainFramePartialForMacOSX");
                    Method mtd = clz.getMethod("setupScreenMenu", MainFrame.class);
                    mtd.invoke(null, mainFrame);
                }
                catch (Throwable ex) {
                    logger.log(Level.CONFIG, "The Apple Java Extensions is not found.", ex);
                }
            }
            mainFrame.showMainFrame();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "Application initiation failed.", ex);
            ErrorMessageHelper.showErrorDialog(null, ex);
            MainFrame.closeAllProfiles();
        }
    }

    public static void main(String[] args) {
        Main.initLogger();
        SwingUtilities.invokeLater(new Main());
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    public static boolean isLinuxOrMacOSX() {
        return isLinux || isMacOSX;
    }

    static {
        String lcOS = System.getProperty("os.name").toLowerCase();
        isMacOSX = lcOS.startsWith("mac os x");
        isLinux = lcOS.indexOf("linux") >= 0;
    }
}

