/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.InformationModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Collections;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InformationTableModel
extends AbstractTableModelWithComboBoxModel<InformationModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames;
    private static final int[] columnWidths;
    public static final int COLUMN_BUTTON;

    InformationTableModel() {
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < columnWidths.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(columnWidths[idx]);
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InformationModel information = (InformationModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return information.getPartsName();
            }
            case 1: {
                return information.getCategoryName();
            }
            case 2: {
                return information.getLayerName();
            }
            case 3: {
                return information.getLayerOrder();
            }
            case 4: {
                return information.getImageSizeStr();
            }
            case 5: {
                return information.getColorTypeStr();
            }
            case 6: {
                return information.getImageResourceName();
            }
            case 7: {
                return information.getButton();
            }
        }
        return "";
    }

    public void sort() {
        Collections.sort(this.elements);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        InformationModel information = (InformationModel)this.getRow(rowIndex);
        if (columnIndex == COLUMN_BUTTON) {
            return information.getButton().isEnabled();
        }
        return false;
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("languages/informationdialog");
        columnNames = new String[]{strings.getProperty("column.partsName"), strings.getProperty("column.categoryName"), strings.getProperty("column.layerName"), strings.getProperty("column.layerOrder"), strings.getProperty("column.imagesize"), strings.getProperty("column.colortype"), strings.getProperty("column.imageName"), strings.getProperty("column.editbtn")};
        COLUMN_BUTTON = 7;
        columnWidths = new int[]{Integer.parseInt(strings.getProperty("column.partsName.width")), Integer.parseInt(strings.getProperty("column.categoryName.width")), Integer.parseInt(strings.getProperty("column.layerName.width")), Integer.parseInt(strings.getProperty("column.layerOrder.width")), Integer.parseInt(strings.getProperty("column.layerOrder.imagesize.width")), Integer.parseInt(strings.getProperty("column.layerOrder.colortype.width")), Integer.parseInt(strings.getProperty("column.imageName.width")), Integer.parseInt(strings.getProperty("column.editbtn.width"))};
    }
}

