/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.AppConfig;
import charactermanaj.model.util.StartupSupport;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StartupSupportForDocBasedData
extends StartupSupport {
    StartupSupportForDocBasedData() {
    }

    protected Map<String, File> getDocBaseMap(DocBaseSignatureStoratage storatage) {
        if (storatage == null) {
            throw new IllegalArgumentException();
        }
        AppConfig appConfig = AppConfig.getInstance();
        File[] charactersDirs = new File[]{appConfig.getSystemCharactersDir(), appConfig.getUserCharactersDir()};
        HashMap<String, File> docBaseSignatures = new HashMap<String, File>();
        for (File charactersDir : charactersDirs) {
            if (charactersDir == null || !charactersDir.exists() || !charactersDir.isDirectory()) continue;
            for (File characterDir : charactersDir.listFiles()) {
                String docBaseSig;
                File characterXml;
                if (!characterDir.isDirectory() || !(characterXml = new File(characterDir, "character.xml")).exists() || (docBaseSig = storatage.getDocBaseSignature(characterXml)) == null) continue;
                docBaseSignatures.put(docBaseSig, characterDir);
            }
        }
        return docBaseSignatures;
    }

    protected Map<String, File> getUUIDMangledNamedMap(File dataDir, String suffix) {
        if (dataDir == null || !dataDir.exists() || !dataDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        HashMap<String, File> uuidMangledFiles = new HashMap<String, File>();
        for (File file : dataDir.listFiles()) {
            String[] sigParts;
            String name = file.getName();
            if (!file.isFile() || suffix != null && suffix.length() != 0 && !name.endsWith(suffix) || (sigParts = name.split("-")).length < 5) continue;
            StringBuilder sig = new StringBuilder();
            for (int idx = 0; idx < 5; ++idx) {
                if (idx != 0) {
                    sig.append("-");
                }
                sig.append(sigParts[idx]);
            }
            uuidMangledFiles.put(sig.toString(), file);
        }
        return uuidMangledFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DocBaseSignatureStoratage {
        NEW_FORMAT{

            public String getDocBaseSignature(File characterXmlFile) {
                URI docBase = characterXmlFile.toURI();
                UserDataFactory userDataFactory = UserDataFactory.getInstance();
                return userDataFactory.getMangledNamedPrefix(docBase);
            }
        }
        ,
        OLD_FORMAT{

            public String getDocBaseSignature(File characterXmlFile) {
                try {
                    URL url = characterXmlFile.toURL();
                    return UUID.nameUUIDFromBytes(url.toString().getBytes()).toString();
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "character.xml\u306e\u30d5\u30a1\u30a4\u30eb\u4f4d\u7f6e\u3092UUID\u5316\u3067\u304d\u307e\u305b\u3093\u3002:" + characterXmlFile, ex);
                    return null;
                }
            }
        };

        private static Logger logger;

        public abstract String getDocBaseSignature(File var1);

        static {
            logger = Logger.getLogger(DocBaseSignatureStoratage.class.getName());
        }
    }
}

