/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.FileUserData;
import charactermanaj.util.UserData;
import java.io.File;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserDataFactory {
    private static final Logger logger = Logger.getLogger(UserDataFactory.class.getName());
    private static UserDataFactory inst = new UserDataFactory();

    public static UserDataFactory getInstance() {
        return inst;
    }

    private UserDataFactory() {
    }

    public File getSpecialDataDir(String name) {
        String ext;
        int pos;
        File userDataDir = ConfigurationDirUtilities.getUserDataDir();
        if (name != null && name.length() > 0 && (pos = name.lastIndexOf(46)) >= 0 && (ext = name.substring(pos + 1)).length() > 0) {
            userDataDir = "ser".equals(ext) ? new File(userDataDir, "caches") : new File(userDataDir, ext + "s");
        }
        if (!userDataDir.exists()) {
            boolean result = userDataDir.mkdirs();
            logger.log(Level.INFO, "makeDir: " + userDataDir + " /succeeded=" + result);
        }
        return userDataDir;
    }

    public UserData getUserData(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return new FileUserData(new File(this.getSpecialDataDir(name), name));
    }

    public UserData getMangledNamedUserData(URI docBase, String name) {
        String prefix = this.getMangledNamedPrefix(docBase);
        return this.getUserData(prefix + "-" + name);
    }

    public String getMangledNamedPrefix(URI docBase) {
        String docBaseStr = docBase == null ? "" : docBase.toString();
        String prefix = UUID.nameUUIDFromBytes(docBaseStr.getBytes()).toString();
        return prefix;
    }
}

