/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.util.StartupSupport;
import charactermanaj.util.DirectoryConfig;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StartupSupportForDocBasedData
extends StartupSupport {
    StartupSupportForDocBasedData() {
    }

    protected Map<String, File> getDocBaseMapInCaches(DocBaseSignatureStoratage storatage) {
        if (storatage == null) {
            throw new IllegalArgumentException();
        }
        DirectoryConfig dirConfig = DirectoryConfig.getInstance();
        File[] charactersDirs = new File[]{dirConfig.getCharactersDir()};
        ArrayList<File> characterXmlFiles = new ArrayList<File>();
        for (File charactersDir : charactersDirs) {
            if (charactersDir == null || !charactersDir.exists() || !charactersDir.isDirectory()) continue;
            for (File characterDir : charactersDir.listFiles()) {
                File characterXml;
                if (!characterDir.isDirectory() || !(characterXml = new File(characterDir, "character.xml")).exists()) continue;
                characterXmlFiles.add(characterXml);
            }
        }
        Map<File, String> docBaseSigMap = storatage.getDocBaseSignature(characterXmlFiles);
        HashMap<String, File> docBaseSignatures = new HashMap<String, File>();
        for (Map.Entry<File, String> entry : docBaseSigMap.entrySet()) {
            docBaseSignatures.put(entry.getValue(), entry.getKey());
        }
        return docBaseSignatures;
    }

    protected Map<String, File> getUUIDMangledNamedMap(File dataDir, String suffix) {
        if (dataDir == null || !dataDir.exists() || !dataDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        HashMap<String, File> uuidMangledFiles = new HashMap<String, File>();
        for (File file : dataDir.listFiles()) {
            String[] sigParts;
            String name = file.getName();
            if (!file.isFile() || suffix != null && suffix.length() != 0 && !name.endsWith(suffix) || (sigParts = name.split("-")).length < 5) continue;
            StringBuilder sig = new StringBuilder();
            for (int idx = 0; idx < 5; ++idx) {
                if (idx != 0) {
                    sig.append("-");
                }
                sig.append(sigParts[idx]);
            }
            uuidMangledFiles.put(sig.toString(), file);
        }
        return uuidMangledFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DocBaseSignatureStoratage {
        NEW_FORMAT{

            @Override
            public Map<File, String> getDocBaseSignature(Collection<File> characterXmlFiles) {
                HashMap<URI, File> uris = new HashMap<URI, File>();
                for (File characterXmlFile : characterXmlFiles) {
                    uris.put(characterXmlFile.toURI(), characterXmlFile);
                }
                UserDataFactory userDataFactory = UserDataFactory.getInstance();
                HashMap<File, String> results = new HashMap<File, String>();
                File storeDir = userDataFactory.getSpecialDataDir("*.ser");
                for (Map.Entry<URI, String> entry : userDataFactory.getMangledNameMap(uris.keySet(), storeDir, true).entrySet()) {
                    File characterXmlFile = (File)uris.get(entry.getKey());
                    String mangledName = entry.getValue();
                    results.put(characterXmlFile, mangledName);
                }
                return results;
            }
        }
        ,
        OLD_FORMAT{

            @Override
            public Map<File, String> getDocBaseSignature(Collection<File> characterXmlFiles) {
                HashMap<File, String> results = new HashMap<File, String>();
                for (File characterXmlFile : characterXmlFiles) {
                    String mangledName;
                    try {
                        URL url = characterXmlFile.toURL();
                        mangledName = UUID.nameUUIDFromBytes(url.toString().getBytes()).toString();
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "character.xml\u306e\u30d5\u30a1\u30a4\u30eb\u4f4d\u7f6e\u3092UUID\u5316\u3067\u304d\u307e\u305b\u3093\u3002:" + characterXmlFile, ex);
                        mangledName = null;
                    }
                    results.put(characterXmlFile, mangledName);
                }
                return results;
            }
        };

        private static Logger logger;

        public abstract Map<File, String> getDocBaseSignature(Collection<File> var1);

        static {
            logger = Logger.getLogger(DocBaseSignatureStoratage.class.getName());
        }
    }
}

