/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsSet;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ManageFavoriteDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "languages/managefavoritesdialog";
    private CharacterData characterData;
    private DefaultListModel listModel;
    private JList list;
    private boolean dirty;

    public ManageFavoriteDialog(JFrame parent, CharacterData characterData) {
        super((Frame)parent, true);
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ManageFavoriteDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("manageFavorites"));
        this.characterData = characterData;
        characterData.getPartsSets();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String dispayValue = ((PartsSet)value).getLocalizedName();
                return super.getListCellRendererComponent((JList<?>)list, dispayValue, index, isSelected, cellHasFocus);
            }
        };
        this.list.setCellRenderer(listCellRenderer);
        AbstractAction actDelete = new AbstractAction(strings.getProperty("remove")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ManageFavoriteDialog.this.onDelete();
            }
        };
        AbstractAction actRename = new AbstractAction(strings.getProperty("rename")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ManageFavoriteDialog.this.onRename();
            }
        };
        JPanel buttonsPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        buttonsPanel.setLayout(gb);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.fill = 1;
        buttonsPanel.add((Component)new JButton(actDelete), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        buttonsPanel.add((Component)new JButton(actRename), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        buttonsPanel.add(Box.createGlue(), gbc);
        JPanel panel2 = new JPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        panel2.setLayout(new BorderLayout());
        AbstractAction actCancel = new AbstractAction(strings.getProperty("close")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ManageFavoriteDialog.this.onClose();
            }
        };
        JButton btnClose = new JButton(actCancel);
        panel2.add((Component)btnClose, "East");
        JScrollPane scr = new JScrollPane(this.list);
        scr.setBorder(BorderFactory.createEtchedBorder());
        scr.setPreferredSize(new Dimension(300, 150));
        contentPane.add((Component)scr, "Center");
        contentPane.add((Component)buttonsPanel, "East");
        contentPane.add((Component)panel2, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnClose);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(127, 0), "deleteFav");
        im.put(KeyStroke.getKeyStroke(27, 0), "closeManageFavoriteDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeManageFavoriteDialog");
        am.put("deleteFav", actDelete);
        am.put("closeManageFavoriteDialog", actCancel);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.initListModel();
        this.list.repaint();
    }

    protected void initListModel() {
        ArrayList<PartsSet> partssets = new ArrayList<PartsSet>();
        for (PartsSet partsset : this.characterData.getPartsSets().values()) {
            if (partsset.isPresetParts()) continue;
            partssets.add(partsset);
        }
        Collections.sort(partssets, new Comparator<PartsSet>(){

            @Override
            public int compare(PartsSet o1, PartsSet o2) {
                int ret = o1.getLocalizedName().compareTo(o2.getLocalizedName());
                if (ret == 0) {
                    ret = o1.getPartsSetId().compareTo(o2.getPartsSetId());
                }
                if (ret == 0) {
                    ret = o1.hashCode() - o2.hashCode();
                }
                return ret;
            }
        });
        this.list.setSelectedIndices(new int[0]);
        this.listModel.removeAllElements();
        for (PartsSet partsset : partssets) {
            this.listModel.addElement(partsset);
        }
    }

    protected void onDelete() {
        Map<String, PartsSet> partsSetMap = this.characterData.getPartsSets();
        for (Object value : this.list.getSelectedValues()) {
            PartsSet partsSet = (PartsSet)value;
            Iterator<Map.Entry<String, PartsSet>> ite = partsSetMap.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, PartsSet> entry = ite.next();
                PartsSet target = entry.getValue();
                if (target != partsSet) continue;
                this.dirty = true;
                ite.remove();
            }
        }
        this.initListModel();
        this.list.repaint();
    }

    protected void onRename() {
        Properties strings;
        String localizedName;
        PartsSet partsSet = (PartsSet)this.list.getSelectedValue();
        if (partsSet != null && (localizedName = JOptionPane.showInputDialog(this, (strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE)).getProperty("inputName"), partsSet.getLocalizedName())) != null) {
            partsSet.setLocalizedName(localizedName);
            this.dirty = true;
            this.list.repaint();
        }
    }

    protected void onClose() {
        this.dispose();
    }

    public boolean isModified() {
        return this.dirty;
    }
}

