/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsFiles;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.PartsDataLoader;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePartsDataLoader
implements PartsDataLoader {
    private File baseDir;

    public FilePartsDataLoader(File baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException();
        }
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> load(PartsCategory category) {
        if (category == null) {
            throw new IllegalArgumentException();
        }
        HashMap<PartsIdentifier, PartsSpec> images = new HashMap<PartsIdentifier, PartsSpec>();
        for (Layer layer : category.getLayers()) {
            File searchDir = new File(this.baseDir, layer.getDir());
            if (!searchDir.exists() || !searchDir.isDirectory()) continue;
            for (File imgFile : searchDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    if (pathname.isFile()) {
                        String lcfname = pathname.getPath().toLowerCase();
                        return lcfname.endsWith(".png");
                    }
                    return false;
                }
            })) {
                PartsIdentifier partsIdentifier;
                PartsSpec partsSpec;
                String partsName = imgFile.getName();
                int extpos = partsName.lastIndexOf(".");
                if (extpos > 0) {
                    partsName = partsName.substring(0, extpos);
                }
                if ((partsSpec = (PartsSpec)images.get(partsIdentifier = new PartsIdentifier(category, partsName, partsName))) == null) {
                    partsSpec = this.createPartsSpec(partsIdentifier);
                    images.put(partsIdentifier, partsSpec);
                }
                PartsFiles parts = partsSpec.getPartsFiles();
                parts.put(layer, new FileImageResource(imgFile));
            }
        }
        return images;
    }

    protected PartsSpec createPartsSpec(PartsIdentifier partsIdentifier) {
        return new PartsSpec(partsIdentifier);
    }
}

