/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.CharacterDataPersistent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class MakeEmbeddedResource {
    public static void main(String[] args) throws Exception {
        String[] fileNames = new String[]{"resources/schema/character.xml.ser", "resources/resource_list.txt"};
        for (int idx = 0; idx < Math.min(args.length, fileNames.length); ++idx) {
            fileNames[idx] = args[idx];
        }
        MakeEmbeddedResource.createDefaultCharacterSer(fileNames[0]);
        MakeEmbeddedResource.createResourceList(fileNames[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createResourceList(String fileName) throws Exception {
        File outiFile = new File(fileName);
        ArrayList<String> resourceList = new ArrayList<String>();
        resourceList.add("_HOW_TO_LOCALIZE.txt");
        File resourceDir = new File("resources");
        for (String dirName : new String[]{"appinfo", "languages", "menu"}) {
            File dir = new File(resourceDir, dirName);
            for (File file : dir.listFiles()) {
                if (!file.isFile()) continue;
                String resourceName = dirName + "/" + file.getName();
                resourceList.add(resourceName);
            }
        }
        String br = "\r\n";
        FileOutputStream fos = new FileOutputStream(outiFile);
        try {
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
            try {
                wr.write("# localized resources" + br);
                for (String resource : resourceList) {
                    wr.write(resource + br);
                }
            }
            finally {
                ((Writer)wr).close();
            }
        }
        finally {
            fos.close();
        }
        System.out.println("make embedded resource : succeeded. file=" + outiFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDefaultCharacterSer(String fileName) throws Exception {
        File outiFile = new File(fileName);
        Locale[] locales = new Locale[]{Locale.ENGLISH, Locale.JAPANESE};
        HashMap<String, CharacterData> characterDataMap = new HashMap<String, CharacterData>();
        for (Locale locale : locales) {
            String lang = locale.getLanguage();
            if (characterDataMap.containsKey(lang)) continue;
            CharacterData cd = MakeEmbeddedResource.loadDefaultCharacterData(locale);
            characterDataMap.put(lang, cd);
        }
        FileOutputStream fos = new FileOutputStream(outiFile);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            try {
                oos.writeObject(characterDataMap);
            }
            finally {
                oos.close();
            }
        }
        finally {
            fos.close();
        }
        System.out.println("make embedded resource : succeeded. file=" + outiFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharacterData loadDefaultCharacterData(Locale locale) throws Exception {
        CharacterData cd;
        URL defaultCharacter = MakeEmbeddedResource.getEmbeddedResourceURL("/schema/character.xml");
        InputStream is = defaultCharacter.openStream();
        try {
            CharacterDataPersistent.DocInfo docInfo = new CharacterDataPersistent.DocInfo();
            docInfo.setFirstElementName("character");
            docInfo.setNamespace("http://charactermanaj.sourceforge.jp/schema/charactermanaj");
            docInfo.setVersion("1.0");
            CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
            cd = persist.loadCharacterDataFromXML(is, null, docInfo, locale);
        }
        finally {
            is.close();
        }
        return cd;
    }

    protected static URL getEmbeddedResourceURL(String schemaName) {
        return CharacterDataPersistent.class.getResource(schemaName);
    }
}

