/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.LoadedImage;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageLoaderImpl
implements ImageLoader {
    private static final Logger logger = Logger.getLogger(ImageLoaderImpl.class.getName());

    public LoadedImage load(ImageResource imageResource) throws IOException {
        if (imageResource == null) {
            throw new IllegalArgumentException();
        }
        BufferedImage img = ImageIO.read(imageResource.openStream());
        if (img == null) {
            logger.log(Level.WARNING, "unsuppoted image: " + imageResource);
            throw new IOException("unsupported image");
        }
        img = this.convertARGB(img);
        long lastModified = imageResource.lastModified();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "load image: " + imageResource + " ;lastModified=" + new Timestamp(lastModified));
        }
        return new LoadedImage(img, lastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage convertARGB(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        int typ = image.getType();
        if (typ == 2) {
            return image;
        }
        BufferedImage img2 = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics g = img2.getGraphics();
        try {
            g.drawImage(image, 0, 0, null);
        }
        finally {
            g.dispose();
        }
        return img2;
    }
}

