/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.filters.ColorConv;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.graphics.io.LoadedImage;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.MainFrame;
import charactermanaj.util.FileUserData;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterDataPersistent {
    public static final String CONFIG_FILE = "character.xml";
    private static final Logger logger = Logger.getLogger(CharacterDataPersistent.class.getName());
    public static final String SAMPLE_IMAGE_FILENAME = "preview.png";
    public static final String VERSION_SIG_1_0 = "1.0";
    public static final String NS = "http://charactermanaj.sourceforge.jp/schema/charactermanaj";
    public static final String NS_PARTSDEF = "http://charactermanaj.sourceforge.jp/schema/charactermanaj-partsdef";
    private static final String CHARACTER_XML_SCHEMA = "/schema/character.xsd";
    private static final String CHARACTER_XML_SCHEMA_0_8 = "/schema/0.8/character.xsd";
    private static final String PARTSSET_XML_SCHEMA = "/schema/partsset.xsd";
    private static final String PARTSSET_XML_SCHEMA_0_8 = "/schema/0.8/partsset.xsd";
    private static final String DEFAULT_CHARACTER_XML = "/schema/character.xml";
    public static final ProfileListErrorHandler DEFAULT_ERROR_HANDLER = new ProfileListErrorHandler(){

        public void occureException(File baseDir, Throwable ex) {
            logger.log(Level.WARNING, "invalid profile. :" + baseDir, ex);
        }
    };
    private HashMap<String, Schema> schemaMap = new HashMap();
    private static final ErrorHandler errorHandler = new ErrorHandler(){

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };
    private static final CharacterDataPersistent singleton = new CharacterDataPersistent();

    private CharacterDataPersistent() {
    }

    public static CharacterDataPersistent getInstance() {
        return singleton;
    }

    public void createProfile(CharacterData characterData) throws IOException {
        File characterPropXML;
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        String id = characterData.getId();
        if (id == null || id.trim().length() == 0) {
            throw new IOException("missing character-id:" + characterData);
        }
        AppConfig appConfig = AppConfig.getInstance();
        File charactersDir = appConfig.getUserCharactersDir();
        if (!charactersDir.exists() && !charactersDir.mkdirs()) {
            throw new IOException("can't create the characters directory. " + charactersDir);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "check characters-dir: " + charactersDir + ": exists=" + charactersDir.exists());
        }
        File baseDir = null;
        String suffix = "";
        String name = characterData.getName();
        if (name == null) {
            name = characterData.getId();
        }
        int retry = 0;
        while ((baseDir = new File(charactersDir, name + suffix)).exists()) {
            if (retry > 100) {
                throw new IOException("character directory conflict.:" + baseDir);
            }
            suffix = this.generateSuffix(retry);
            ++retry;
        }
        if (!baseDir.exists()) {
            if (!baseDir.mkdirs()) {
                throw new IOException("can't create directory. " + baseDir);
            }
            logger.log(Level.INFO, "create character-dir: " + baseDir);
        }
        if ((characterPropXML = new File(baseDir, CONFIG_FILE)).exists() && !characterPropXML.isFile()) {
            throw new IOException("character.xml is not a regular file.:" + characterPropXML);
        }
        if (characterPropXML.exists() && !characterPropXML.canWrite()) {
            throw new IOException("character.xml is not writable.:" + characterPropXML);
        }
        URI docBase = characterPropXML.toURI();
        characterData.setDocBase(docBase);
        if (characterData.getRev() == null) {
            characterData.setRev(this.generateRev());
        }
        this.saveCharacterDataToXML(characterData);
        this.preparePartsDir(characterData);
    }

    public String generateRev() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        return fmt.format(new Date());
    }

    protected String generateSuffix(int retryCount) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        String suffix = "_" + fmt.format(new Date());
        if (retryCount > 0) {
            suffix = suffix + "_" + retryCount;
        }
        return suffix;
    }

    public void updateProfile(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        characterData.checkWritable();
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        this.saveCharacterDataToXML(characterData);
        this.preparePartsDir(characterData);
    }

    protected void preparePartsDir(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        characterData.checkWritable();
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        URI docBase = characterData.getDocBase();
        if (!"file".equals(docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002:" + docBase);
        }
        File docBaseFile = new File(docBase);
        File baseDir = docBaseFile.getParentFile();
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new IOException("can't create directory. " + baseDir);
        }
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                File layerDir;
                String dir = layer.getDir();
                if (dir == null || (layerDir = new File(baseDir, layer.getDir())).exists() || layerDir.mkdirs()) continue;
                throw new IOException("can't create directory. " + layerDir);
            }
        }
    }

    public List<CharacterData> listProfiles(ProfileListErrorHandler errorHandler) {
        AppConfig appConfig = AppConfig.getInstance();
        File[] baseDirs = new File[]{appConfig.getSystemCharactersDir(), appConfig.getUserCharactersDir()};
        ArrayList<CharacterData> profiles = new ArrayList<CharacterData>();
        for (File baseDir : baseDirs) {
            if (baseDir == null || !baseDir.exists() || !baseDir.isDirectory()) continue;
            for (File dir : baseDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    boolean accept;
                    boolean bl = accept = pathname.isDirectory() && !pathname.getName().startsWith(".");
                    if (accept) {
                        File configFile = new File(pathname, CharacterDataPersistent.CONFIG_FILE);
                        accept = configFile.exists() && configFile.canRead();
                    }
                    return accept;
                }
            })) {
                File characterDataXml = new File(dir, CONFIG_FILE);
                if (!characterDataXml.exists()) continue;
                try {
                    File docBaseFile = new File(dir, CONFIG_FILE);
                    URI docBase = docBaseFile.toURI();
                    CharacterData characterData = this.loadProfile(docBase);
                    profiles.add(characterData);
                }
                catch (Exception ex) {
                    if (errorHandler == null) continue;
                    errorHandler.occureException(dir, ex);
                }
            }
        }
        Collections.sort(profiles, CharacterData.SORT_DISPLAYNAME);
        return Collections.unmodifiableList(profiles);
    }

    protected UserData getCharacterDataCacheUserFile(URI docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException();
        }
        String name = new File(docBase).getName();
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        return userDataFactory.getMangledNamedUserData(docBase, name + "-cache.ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterData loadProfile(URI docBase) throws IOException {
        long lastModified;
        if (docBase == null) {
            throw new IllegalArgumentException();
        }
        URL docBaseURL = docBase.toURL();
        URLConnection conn = docBaseURL.openConnection();
        try {
            lastModified = conn.getLastModified();
        }
        finally {
            conn.getInputStream().close();
            conn = null;
        }
        UserData serializedFile = this.getCharacterDataCacheUserFile(docBase);
        if (serializedFile.exists() && lastModified > 0L && serializedFile.lastModified() >= lastModified) {
            try {
                CharacterData deserializedCd = (CharacterData)serializedFile.load();
                URI deserializedDocBase = deserializedCd.getDocBase();
                if (deserializedDocBase == null || !docBase.equals(deserializedDocBase)) {
                    throw new IOException("docBase mismatch. actual=" + deserializedDocBase + "/expected=" + docBase);
                }
                return deserializedCd;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "cached character.xml loading failed.: " + docBase, ex);
            }
        }
        CharacterData characterData = this.loadCharacterDataFromXML(docBase);
        try {
            serializedFile.save(characterData);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "cached character.xml creation failed.: " + docBase, ex);
        }
        return characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterData loadCharacterDataFromXML(URI docBase) throws IOException {
        CharacterData cd;
        DocInfo docInfo;
        if (docBase == null) {
            throw new IllegalArgumentException();
        }
        URL docBaseURL = docBase.toURL();
        InputStream is = docBaseURL.openStream();
        try {
            docInfo = this.readDocumentType(is);
            logger.log(Level.INFO, "docinfo: " + docInfo);
        }
        finally {
            is.close();
        }
        if (docInfo == null) {
            throw new IOException("unknown document type.");
        }
        is = docBaseURL.openStream();
        try {
            cd = this.loadCharacterDataFromXML(is, docBase, docInfo);
        }
        finally {
            is.close();
        }
        return cd;
    }

    public DocInfo readDocumentType(InputStream is) throws IOException {
        SAXParser saxParser;
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Exception.", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("JAXP Configuration Exception.", ex);
        }
        try {
            final DocInfo[] result = new DocInfo[1];
            saxParser.parse(is, new DefaultHandler(){
                private int elmCount = 0;

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (this.elmCount == 0) {
                        String version = attributes.getValue("version");
                        String namespace = attributes.getValue("xmlns");
                        DocInfo docInfo = new DocInfo();
                        docInfo.setFirstElementName(qName);
                        docInfo.setVersion(version);
                        docInfo.setNamespace(namespace);
                        result[0] = docInfo;
                    }
                    ++this.elmCount;
                }
            });
            return result[0];
        }
        catch (SAXException ex) {
            logger.log(Level.INFO, "character.xml check failed.", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterData createDefaultCharacterData() {
        try {
            CharacterData cd;
            URL defaultCharacter = this.getSchemaURL(DEFAULT_CHARACTER_XML);
            InputStream is = defaultCharacter.openStream();
            try {
                DocInfo docInfo = new DocInfo();
                docInfo.setFirstElementName("character");
                docInfo.setNamespace(NS);
                docInfo.setVersion(VERSION_SIG_1_0);
                cd = this.loadCharacterDataFromXML(is, null, docInfo);
            }
            finally {
                is.close();
            }
            return cd;
        }
        catch (IOException ex) {
            throw new RuntimeException("can not create the default profile from application's resource", ex);
        }
    }

    public CharacterData loadCharacterDataFromXML(InputStream is, URI docBase, DocInfo docInfo) throws IOException {
        Document doc;
        if (is == null || docInfo == null) {
            throw new IllegalArgumentException();
        }
        Schema schema = this.loadSchema(docInfo);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setSchema(schema);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            final ArrayList errors = new ArrayList();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }

                public void warning(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }
            });
            doc = builder.parse(is);
            if (errors.size() > 0) {
                throw (SAXParseException)errors.get(0);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Exception.", ex);
        }
        catch (SAXException ex) {
            IOException ex2 = new IOException("CharacterData read failed.");
            ex2.initCause(ex);
            throw ex2;
        }
        XPath xpath = this.createXPath(docInfo);
        CharacterData characterData = new CharacterData();
        characterData.setDocBase(docBase);
        try {
            Node nodeVersion = (Node)xpath.evaluate("/pre:character/@version", doc, XPathConstants.NODE);
            if (!nodeVersion.getTextContent().equals(VERSION_SIG_1_0)) {
                throw new IOException("unsupported version: " + nodeVersion.toString());
            }
            Node nodeCharacterId = (Node)xpath.evaluate("/pre:character/@id", doc, XPathConstants.NODE);
            String characterId = nodeCharacterId.getTextContent().trim();
            characterData.setId(characterId);
            Node nodeCharacterRev = (Node)xpath.evaluate("/pre:character/@rev", doc, XPathConstants.NODE);
            String characterRev = nodeCharacterRev.getTextContent().trim();
            characterData.setRev(characterRev);
            Locale locale = Locale.getDefault();
            String lang = locale.getLanguage();
            Node nodeCharacterName = (Node)xpath.evaluate("/pre:character/pre:name[lang('" + lang + "')]", doc, XPathConstants.NODE);
            if (nodeCharacterName == null) {
                nodeCharacterName = (Node)xpath.evaluate("/pre:character/pre:name[position() = 1]", doc, XPathConstants.NODE);
            }
            String characterName = nodeCharacterName.getTextContent();
            characterData.setName(characterName);
            Node nodeAuthor = (Node)xpath.evaluate("/pre:character/pre:information/pre:author[lang('" + lang + "')]", doc, XPathConstants.NODE);
            if (nodeAuthor == null) {
                nodeAuthor = (Node)xpath.evaluate("/pre:character/pre:information/pre:author[position() = 1]", doc, XPathConstants.NODE);
            }
            characterData.setAuthor(nodeAuthor == null ? "" : nodeAuthor.getTextContent().trim());
            Node nodeDescription = (Node)xpath.evaluate("/pre:character/pre:information/pre:description[lang('" + lang + "')]", doc, XPathConstants.NODE);
            if (nodeDescription == null) {
                nodeDescription = (Node)xpath.evaluate("/pre:character/pre:information/pre:description[position() = 1]", doc, XPathConstants.NODE);
            }
            String note = nodeDescription == null ? "" : nodeDescription.getTextContent().trim();
            characterData.setDescription(note);
            int width = Integer.parseInt(((Node)xpath.evaluate("/pre:character/pre:image-size/pre:width", doc, XPathConstants.NODE)).getTextContent());
            int height = Integer.parseInt(((Node)xpath.evaluate("/pre:character/pre:image-size/pre:height", doc, XPathConstants.NODE)).getTextContent());
            characterData.setImageSize(new Dimension(width, height));
            XPathExpression expSettingsEntry = xpath.compile("pre:character/pre:settings/pre:entry");
            for (Node nodeSettingsEntry : this.iterable((NodeList)expSettingsEntry.evaluate(doc, XPathConstants.NODESET))) {
                Element elmSettingsEntry = (Element)nodeSettingsEntry;
                String key = elmSettingsEntry.getAttribute("key");
                String value = elmSettingsEntry.getTextContent();
                characterData.setProperty(key, value);
            }
            ArrayList<ColorGroup> colorGroups = new ArrayList<ColorGroup>();
            XPathExpression expDisplayNameByLocale = xpath.compile("pre:display-name[lang('" + lang + "')]");
            XPathExpression expDisplayNameByDefault = xpath.compile("pre:display-name[position() = 1]");
            XPathExpression expColorGroupId = xpath.compile("@id");
            for (Node nodeColorGroup : this.iterable((NodeList)xpath.evaluate("/pre:character/pre:colorGroups/pre:colorGroup", doc, XPathConstants.NODESET))) {
                String id = ((Node)expColorGroupId.evaluate(nodeColorGroup, XPathConstants.NODE)).getTextContent().trim();
                Node nodeDisplayName = (Node)expDisplayNameByLocale.evaluate(nodeColorGroup, XPathConstants.NODE);
                if (nodeDisplayName == null) {
                    nodeDisplayName = (Node)expDisplayNameByDefault.evaluate(nodeColorGroup, XPathConstants.NODE);
                }
                String colorGroupDisplayName = nodeDisplayName.getTextContent();
                ColorGroup colorGroup = new ColorGroup(id, colorGroupDisplayName);
                colorGroups.add(colorGroup);
            }
            characterData.setColorGroups(colorGroups);
            ArrayList<PartsCategory> categories = new ArrayList<PartsCategory>();
            XPathExpression expCategoryId = xpath.compile("@id");
            XPathExpression expMultipleSelectable = xpath.compile("@multipleSelectable");
            XPathExpression expLayers = xpath.compile("pre:layers/pre:layer");
            XPathExpression expVisibleRows = xpath.compile("pre:visible-rows");
            XPathExpression expLayerOrder = xpath.compile("pre:order");
            XPathExpression expLayerColorGroup = xpath.compile("pre:colorGroup");
            XPathExpression expLayerDir = xpath.compile("pre:dir");
            for (Node nodeCategory : this.iterable((NodeList)xpath.evaluate("/pre:character/pre:categories/pre:category", doc, XPathConstants.NODESET))) {
                String categoryId = ((Node)expCategoryId.evaluate(nodeCategory, XPathConstants.NODE)).getTextContent().trim();
                boolean multipleSelectable = Boolean.parseBoolean(((Node)expMultipleSelectable.evaluate(nodeCategory, XPathConstants.NODE)).getTextContent());
                int visibleRows = Integer.parseInt(((Node)expVisibleRows.evaluate(nodeCategory, XPathConstants.NODE)).getTextContent());
                Node nodeDisplayName = (Node)expDisplayNameByLocale.evaluate(nodeCategory, XPathConstants.NODE);
                if (nodeDisplayName == null) {
                    nodeDisplayName = (Node)expDisplayNameByDefault.evaluate(nodeCategory, XPathConstants.NODE);
                }
                String categoryDisplayName = nodeDisplayName.getTextContent();
                ArrayList<Layer> layers = new ArrayList<Layer>();
                for (Node nodeLayer : this.iterable((NodeList)expLayers.evaluate(nodeCategory, XPathConstants.NODESET))) {
                    NamedNodeMap attr = nodeLayer.getAttributes();
                    String layerId = attr.getNamedItem("id").getTextContent().trim();
                    String layerDir = ((Node)expLayerDir.evaluate(nodeLayer, XPathConstants.NODE)).getTextContent();
                    int order = Integer.valueOf(((Node)expLayerOrder.evaluate(nodeLayer, XPathConstants.NODE)).getTextContent());
                    Node nodeLayerDisplayName = (Node)expDisplayNameByLocale.evaluate(nodeLayer, XPathConstants.NODE);
                    if (nodeLayerDisplayName == null) {
                        nodeLayerDisplayName = (Node)expDisplayNameByDefault.evaluate(nodeLayer, XPathConstants.NODE);
                    }
                    String layerDisplayName = nodeLayerDisplayName.getTextContent();
                    Node nodeLayerColorGroup = (Node)expLayerColorGroup.evaluate(nodeLayer, XPathConstants.NODE);
                    ColorGroup colorGroup = null;
                    boolean initSync = false;
                    if (nodeLayerColorGroup != null) {
                        NamedNodeMap attrColorGroup = nodeLayerColorGroup.getAttributes();
                        String colorGroupRefId = attrColorGroup.getNamedItem("refid").getTextContent().trim();
                        colorGroup = characterData.getColorGroup(colorGroupRefId);
                        initSync = Boolean.valueOf(attrColorGroup.getNamedItem("init-sync").getTextContent());
                    }
                    Layer layer = new Layer(layerId, layerDisplayName, order, colorGroup, initSync, layerDir);
                    layers.add(layer);
                }
                PartsCategory category = new PartsCategory(categories.size(), categoryId, categoryDisplayName, multipleSelectable, visibleRows, layers.toArray(new Layer[layers.size()]));
                categories.add(category);
            }
            characterData.setPartsCategories(categories.toArray(new PartsCategory[categories.size()]));
            Node nodePresets = (Node)xpath.evaluate("/pre:character/pre:presets", doc, XPathConstants.NODE);
            if (nodePresets != null) {
                this.loadPartsSet(characterData, nodePresets, true, docInfo);
            }
        }
        catch (XPathExpressionException ex) {
            IOException ex2 = new IOException("CharacterData invalid format.");
            ex2.initCause(ex);
            throw ex2;
        }
        return characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCharacterDataToXML(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        characterData.checkWritable();
        if (!characterData.isValid()) {
            throw new IOException("invalid profile: " + characterData);
        }
        URI docBase = characterData.getDocBase();
        if (!"file".equals(docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093: " + docBase);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.writeXMLCharacterData(characterData, bos);
        }
        finally {
            bos.close();
        }
        File characterPropXML = new File(docBase);
        File baseDir = characterPropXML.getParentFile();
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            logger.log(Level.WARNING, "can't create directory. " + baseDir);
        }
        FileOutputStream fos = new FileOutputStream(characterPropXML);
        try {
            fos.write(bos.toByteArray());
        }
        finally {
            fos.close();
        }
    }

    public void writeXMLCharacterData(CharacterData characterData, OutputStream outstm) throws IOException {
        Transformer tfmr;
        Element nodePresets;
        Document doc;
        if (outstm == null || characterData == null) {
            throw new IllegalArgumentException();
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration failed.", ex);
        }
        Element root = doc.createElementNS(NS, "character");
        root.setAttribute("version", VERSION_SIG_1_0);
        root.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://charactermanaj.sourceforge.jp/schema/charactermanaj character.xsd");
        root.setAttribute("id", characterData.getId());
        root.setAttribute("rev", characterData.getRev());
        doc.appendChild(root);
        Element nodeName = doc.createElementNS(NS, "name");
        Attr attrLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        attrLang.setValue(lang);
        nodeName.setAttributeNodeNS(attrLang);
        nodeName.setTextContent(characterData.getName());
        root.appendChild(nodeName);
        String author = characterData.getAuthor();
        String description = characterData.getDescription();
        if (author != null && author.length() > 0 || description != null && description.length() > 0) {
            Element nodeInfomation = doc.createElementNS(NS, "information");
            if (author != null && author.length() > 0) {
                Element nodeAuthor = doc.createElementNS(NS, "author");
                Attr attrNodeAuthorLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrNodeAuthorLang.setValue(lang);
                nodeAuthor.setAttributeNodeNS(attrNodeAuthorLang);
                nodeAuthor.setTextContent(author);
                nodeInfomation.appendChild(nodeAuthor);
            }
            if (description != null && description.length() > 0) {
                description = description.replace("\r\n", "\n");
                description = description.replace("\r", "\n");
                Element nodeDescription = doc.createElementNS(NS, "description");
                Attr attrNodeDescriptionLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrNodeDescriptionLang.setValue(lang);
                nodeDescription.setAttributeNodeNS(attrNodeDescriptionLang);
                nodeDescription.setTextContent(description);
                nodeInfomation.appendChild(nodeDescription);
            }
            root.appendChild(nodeInfomation);
        }
        Element nodeSize = doc.createElementNS(NS, "image-size");
        Element nodeWidth = doc.createElementNS(NS, "width");
        nodeWidth.setTextContent(Integer.toString((int)characterData.getImageSize().getWidth()));
        Element nodeHeight = doc.createElementNS(NS, "height");
        nodeHeight.setTextContent(Integer.toString((int)characterData.getImageSize().getHeight()));
        nodeSize.appendChild(nodeWidth);
        nodeSize.appendChild(nodeHeight);
        root.appendChild(nodeSize);
        Element nodeSettings = doc.createElementNS(NS, "settings");
        root.appendChild(nodeSettings);
        for (String settingsEntryName : characterData.getPropertyNames()) {
            String value = characterData.getProperty(settingsEntryName);
            if (value == null) continue;
            Element nodeEntry = doc.createElementNS(NS, "entry");
            nodeEntry.setAttribute("key", settingsEntryName);
            nodeEntry.setTextContent(value);
            nodeSettings.appendChild(nodeEntry);
        }
        Element nodeCategories = doc.createElementNS(NS, "categories");
        for (PartsCategory category : characterData.getPartsCategories()) {
            Element nodeCategory = doc.createElementNS(NS, "category");
            nodeCategory.setAttribute("id", category.getCategoryId());
            nodeCategory.setAttribute("multipleSelectable", category.isMultipleSelectable() ? "true" : "false");
            Element nodeVisibleRows = doc.createElementNS(NS, "visible-rows");
            nodeVisibleRows.setTextContent(Integer.toString(category.getVisibleRows()));
            nodeCategory.appendChild(nodeVisibleRows);
            Element nodeCategoryName = doc.createElementNS(NS, "display-name");
            Attr attrCategoryNameLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
            attrCategoryNameLang.setValue(lang);
            nodeCategoryName.setAttributeNodeNS(attrCategoryNameLang);
            nodeCategoryName.setTextContent(category.getLocalizedCategoryName());
            nodeCategory.appendChild(nodeCategoryName);
            Element nodeLayers = doc.createElementNS(NS, "layers");
            for (Layer layer : category.getLayers()) {
                Element nodeLayer = doc.createElementNS(NS, "layer");
                nodeLayer.setAttribute("id", layer.getId());
                Element nodeLayerName = doc.createElementNS(NS, "display-name");
                Attr attrLayerNameLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrLayerNameLang.setValue(lang);
                nodeLayerName.setAttributeNodeNS(attrLayerNameLang);
                nodeLayerName.setTextContent(layer.getLocalizedName());
                nodeLayer.appendChild(nodeLayerName);
                Element nodeOrder = doc.createElementNS(NS, "order");
                nodeOrder.setTextContent(Integer.toString(layer.getOrder()));
                nodeLayer.appendChild(nodeOrder);
                ColorGroup colorGroup = layer.getColorGroup();
                if (colorGroup != null && colorGroup.isEnabled()) {
                    Element nodeColorGroup = doc.createElementNS(NS, "colorGroup");
                    nodeColorGroup.setAttribute("refid", colorGroup.getId());
                    nodeColorGroup.setAttribute("init-sync", layer.isInitSync() ? "true" : "false");
                    nodeLayer.appendChild(nodeColorGroup);
                }
                Element nodeDir = doc.createElementNS(NS, "dir");
                nodeDir.setTextContent(layer.getDir());
                nodeLayer.appendChild(nodeDir);
                nodeLayers.appendChild(nodeLayer);
            }
            nodeCategory.appendChild(nodeLayers);
            nodeCategories.appendChild(nodeCategory);
        }
        root.appendChild(nodeCategories);
        Collection<ColorGroup> colorGroups = characterData.getColorGroups();
        if (colorGroups.size() > 0) {
            Element nodeColorGroups = doc.createElementNS(NS, "colorGroups");
            int colorGroupCount = 0;
            for (ColorGroup colorGroup : colorGroups) {
                if (!colorGroup.isEnabled()) continue;
                Element nodeColorGroup = doc.createElementNS(NS, "colorGroup");
                nodeColorGroup.setAttribute("id", colorGroup.getId());
                Element nodeColorGroupName = doc.createElementNS(NS, "display-name");
                Attr attrColorGroupNameLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrColorGroupNameLang.setValue(lang);
                nodeColorGroupName.setAttributeNodeNS(attrColorGroupNameLang);
                nodeColorGroupName.setTextContent(colorGroup.getLocalizedName());
                nodeColorGroup.appendChild(nodeColorGroupName);
                nodeColorGroups.appendChild(nodeColorGroup);
                ++colorGroupCount;
            }
            if (colorGroupCount > 0) {
                root.appendChild(nodeColorGroups);
            }
        }
        if (this.writePartsSetElements(doc, nodePresets = doc.createElementNS(NS, "presets"), characterData, true, false) > 0) {
            root.appendChild(nodePresets);
        }
        TransformerFactory txFactory = TransformerFactory.newInstance();
        txFactory.setAttribute("indent-number", 4);
        try {
            tfmr = txFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        tfmr.setOutputProperty("indent", "yes");
        String encoding = "UTF-8";
        tfmr.setOutputProperty("encoding", "UTF-8");
        try {
            tfmr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(outstm, Charset.forName("UTF-8"))));
        }
        catch (TransformerException ex) {
            IOException ex2 = new IOException("XML Convert failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFavorites(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserData favoritesData = this.getFavoritesUserData(characterData, "xml");
        OutputStream os = favoritesData.getOutputStream();
        try {
            this.saveFavorites(characterData, os);
        }
        finally {
            os.close();
        }
        UserData favoritesSer = this.getFavoritesUserData(characterData, "ser");
        Collection<PartsSet> partsSetsOrg = characterData.getPartsSets().values();
        ArrayList<PartsSet> partsSets = new ArrayList<PartsSet>(partsSetsOrg);
        favoritesSer.save(partsSets);
    }

    protected UserData getFavoritesUserData(CharacterData characterData, String serializeType) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        URI docBase = characterData.getDocBase();
        try {
            if ("xml".equals(serializeType)) {
                File characterDir = new File(docBase).getParentFile();
                return new FileUserData(new File(characterDir, "favorites.xml"));
            }
            if ("ser".equals(serializeType)) {
                String dataname = "favorites.ser";
                UserData favoritesData = userDataFactory.getMangledNamedUserData(docBase, dataname);
                return favoritesData;
            }
            throw new UnsupportedOperationException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u5f62\u5f0f\u3067\u3059: " + serializeType);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "docBase\u3082\u3057\u304f\u306f\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba\u30bf\u30a4\u30d7\u304c\u4e0d\u6b63\u3067\u3059\u3002" + docBase + "/type=" + serializeType, ex);
            throw new RuntimeException(ex);
        }
    }

    protected void saveFavorites(CharacterData characterData, OutputStream outstm) throws IOException {
        Transformer tfmr;
        Document doc;
        if (characterData == null || outstm == null) {
            throw new IllegalArgumentException();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Exception.", ex);
        }
        Element root = doc.createElementNS(NS, "partssets");
        root.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://charactermanaj.sourceforge.jp/schema/charactermanaj partsset.xsd");
        doc.appendChild(root);
        this.writePartsSetElements(doc, root, characterData, false, true);
        TransformerFactory txFactory = TransformerFactory.newInstance();
        txFactory.setAttribute("indent-number", 4);
        try {
            tfmr = txFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        tfmr.setOutputProperty("indent", "yes");
        String encoding = "UTF-8";
        tfmr.setOutputProperty("encoding", "UTF-8");
        try {
            tfmr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(outstm, Charset.forName("UTF-8"))));
        }
        catch (TransformerException ex) {
            IOException ex2 = new IOException("XML Convert failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    protected int writePartsSetElements(Document doc, Element baseElement, CharacterData characterData, boolean writePresets, boolean writeFavorites) {
        PartsSet defaultPartsSet;
        String defaultPresetId;
        Map<String, PartsSet> partsSetMap = characterData.getPartsSets();
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        HashMap<String, PartsSet> registeredPartsSetMap = new HashMap<String, PartsSet>();
        for (Map.Entry<String, PartsSet> partsSetsEntry : partsSetMap.entrySet()) {
            double[] affineTransformParameter;
            PartsSet partsSet = partsSetsEntry.getValue();
            if (partsSet.isPresetParts() && !writePresets || !partsSet.isPresetParts() && !writeFavorites || partsSet.isEmpty()) continue;
            String partsSetId = partsSet.getPartsSetId();
            String localizedName = partsSet.getLocalizedName();
            Element nodePreset = doc.createElementNS(NS, "preset");
            nodePreset.setAttribute("id", partsSetId);
            baseElement.appendChild(nodePreset);
            registeredPartsSetMap.put(partsSet.getPartsSetId(), partsSet);
            Element nodeName = doc.createElementNS(NS, "display-name");
            Attr attrLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
            attrLang.setValue(lang);
            nodeName.setAttributeNode(attrLang);
            nodeName.setTextContent(localizedName);
            nodePreset.appendChild(nodeName);
            Color bgColor = partsSet.getBgColor();
            if (bgColor != null) {
                Element nodeBgColor = doc.createElementNS(NS, "background-color");
                nodeBgColor.setAttribute("color", "#" + Integer.toHexString(bgColor.getRGB() & 0xFFFFFF));
                nodePreset.appendChild(nodeBgColor);
            }
            if ((affineTransformParameter = partsSet.getAffineTransformParameter()) != null) {
                Element nodeAffineTransform = doc.createElementNS(NS, "affine-transform-parameter");
                StringBuilder tmp = new StringBuilder();
                for (double affineItem : affineTransformParameter) {
                    if (tmp.length() > 0) {
                        tmp.append(" ");
                    }
                    tmp.append(Double.toString(affineItem));
                }
                nodeAffineTransform.setTextContent(tmp.toString());
                nodePreset.appendChild(nodeAffineTransform);
            }
            for (Map.Entry<PartsCategory, List<PartsIdentifier>> entry : partsSet.entrySet()) {
                PartsCategory partsCategory = entry.getKey();
                Element nodeCategory = doc.createElementNS(NS, "category");
                nodeCategory.setAttribute("refid", partsCategory.getCategoryId());
                nodePreset.appendChild(nodeCategory);
                List<PartsIdentifier> partsIdentifiers = entry.getValue();
                for (PartsIdentifier partsIdentifier : partsIdentifiers) {
                    String partsName = partsIdentifier.getPartsName();
                    Element nodeParts = doc.createElementNS(NS, "parts");
                    nodeParts.setAttribute("name", partsName);
                    nodeCategory.appendChild(nodeParts);
                    PartsColorInfo partsColorInfo = partsSet.getColorInfo(partsIdentifier);
                    if (partsColorInfo == null) continue;
                    Element nodeColor = doc.createElementNS(NS, "color");
                    nodeParts.appendChild(nodeColor);
                    for (Map.Entry<Layer, ColorInfo> colorInfoEntry : partsColorInfo.entrySet()) {
                        Object[][] rgbArgss;
                        Layer layer = colorInfoEntry.getKey();
                        ColorInfo colorInfo = colorInfoEntry.getValue();
                        Element nodeLayer = doc.createElementNS(NS, "layer");
                        nodeLayer.setAttribute("refid", layer.getId());
                        nodeColor.appendChild(nodeLayer);
                        ColorGroup colorGroup = colorInfo.getColorGroup();
                        boolean colorSync = colorInfo.isSyncColorGroup();
                        if (colorGroup.isEnabled()) {
                            Element nodeColorGroup = doc.createElementNS(NS, "color-group");
                            nodeColorGroup.setAttribute("group", colorGroup.getId());
                            nodeColorGroup.setAttribute("synchronized", colorSync ? "true" : "false");
                            nodeLayer.appendChild(nodeColorGroup);
                        }
                        ColorConvertParameter param = colorInfo.getColorParameter();
                        Element nodeRGB = doc.createElementNS(NS, "rgb");
                        for (Object[] rgbArgs : rgbArgss = new Object[][]{{"red", param.getOffsetR(), Float.valueOf(param.getFactorR()), Float.valueOf(param.getGammaR())}, {"green", param.getOffsetG(), Float.valueOf(param.getFactorG()), Float.valueOf(param.getGammaG())}, {"blue", param.getOffsetB(), Float.valueOf(param.getFactorB()), Float.valueOf(param.getGammaB())}, {"alpha", param.getOffsetA(), Float.valueOf(param.getFactorA()), Float.valueOf(param.getGammaA())}}) {
                            Element nodeRGBItem = doc.createElementNS(NS, rgbArgs[0].toString());
                            nodeRGBItem.setAttribute("offset", rgbArgs[1].toString());
                            nodeRGBItem.setAttribute("factor", rgbArgs[2].toString());
                            nodeRGBItem.setAttribute("gamma", rgbArgs[3].toString());
                            nodeRGB.appendChild(nodeRGBItem);
                        }
                        nodeLayer.appendChild(nodeRGB);
                        Element nodeHSB = doc.createElementNS(NS, "hsb");
                        nodeHSB.setAttribute("hue", Float.toString(param.getHue()));
                        nodeHSB.setAttribute("saturation", Float.toString(param.getSaturation()));
                        nodeHSB.setAttribute("brightness", Float.toString(param.getBrightness()));
                        nodeLayer.appendChild(nodeHSB);
                        Element nodeRGBReplace = doc.createElementNS(NS, "rgb-replace");
                        ColorConv colorConv = param.getColorReplace();
                        if (colorConv == null) {
                            colorConv = ColorConv.NONE;
                        }
                        nodeRGBReplace.setAttribute("replace-type", colorConv.name());
                        nodeRGBReplace.setAttribute("gray", Float.toString(param.getGrayLevel()));
                        nodeLayer.appendChild(nodeRGBReplace);
                    }
                }
            }
        }
        if (writePresets && (defaultPresetId = characterData.getDefaultPartsSetId()) != null && defaultPresetId.length() > 0 && (defaultPartsSet = (PartsSet)registeredPartsSetMap.get(defaultPresetId)) != null && defaultPartsSet.isPresetParts()) {
            baseElement.setAttribute("default-preset", defaultPresetId);
        }
        return registeredPartsSetMap.size();
    }

    protected void loadPartsSet(CharacterData characterData, Node nodePartssets, boolean presetParts, DocInfo docInfo) throws XPathExpressionException {
        logger.log(Level.INFO, "loadPartsSet: " + characterData + " /presetParts=" + presetParts);
        XPath xpath = this.createXPath(docInfo);
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        XPathExpression expPresets = xpath.compile("pre:preset");
        XPathExpression expDisplayNameByLocale = xpath.compile("pre:display-name[lang('" + lang + "')]");
        XPathExpression expDisplayNameByDefault = xpath.compile("pre:display-name[position() = 1]");
        XPathExpression expId = xpath.compile("@id");
        XPathExpression expRefId = xpath.compile("@refid");
        XPathExpression expName = xpath.compile("@name");
        XPathExpression expCategories = xpath.compile("pre:category");
        XPathExpression expParts = xpath.compile("pre:parts");
        XPathExpression expLayers = xpath.compile("pre:color/pre:layer");
        XPathExpression expColorGroup = xpath.compile("pre:color-group");
        XPathExpression expHsb = xpath.compile("pre:hsb");
        XPathExpression expRgb = xpath.compile("pre:rgb/pre:red|pre:rgb/pre:green|pre:rgb/pre:blue|pre:rgb/pre:alpha");
        XPathExpression expRgbReplace = xpath.compile("pre:rgb-replace");
        XPathExpression expBgColor = xpath.compile("pre:background-color/@color");
        XPathExpression expAffineTrns = xpath.compile("pre:affine-transform-parameter");
        String defaultPresetId = null;
        Node nodeDefaultPreset = (Node)xpath.evaluate("@default-preset", nodePartssets, XPathConstants.NODE);
        if (nodeDefaultPreset != null) {
            defaultPresetId = nodeDefaultPreset.getTextContent().trim();
        }
        for (Node nodePreset : this.iterable((NodeList)expPresets.evaluate(nodePartssets, XPathConstants.NODESET))) {
            String strParams;
            Node nodeAffineTrans;
            Node nodeDisplayName;
            String partsSetId = ((Node)expId.evaluate(nodePreset, XPathConstants.NODE)).getTextContent().trim();
            if (defaultPresetId == null) {
                defaultPresetId = partsSetId;
            }
            if ((nodeDisplayName = (Node)expDisplayNameByLocale.evaluate(nodePreset, XPathConstants.NODE)) == null) {
                nodeDisplayName = (Node)expDisplayNameByDefault.evaluate(nodePreset, XPathConstants.NODE);
            }
            String displayName = nodeDisplayName.getTextContent();
            PartsSet partsSet = new PartsSet();
            partsSet.setPartsSetId(partsSetId);
            partsSet.setLocalizedName(displayName);
            partsSet.setPresetParts(presetParts);
            Node nodeBgColor = (Node)expBgColor.evaluate(nodePreset, XPathConstants.NODE);
            if (nodeBgColor != null) {
                String bgColorStr = nodeBgColor.getTextContent().trim();
                try {
                    Color bgColor = Color.decode(bgColorStr);
                    partsSet.setBgColor(bgColor);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "bgColor parameter is invalid. :" + bgColorStr, ex);
                }
            }
            if ((nodeAffineTrans = (Node)expAffineTrns.evaluate(nodePreset, XPathConstants.NODE)) != null && (strParams = nodeAffineTrans.getTextContent()) != null && strParams.trim().length() > 0) {
                try {
                    ArrayList<Double> affineTransformParameterArr = new ArrayList<Double>();
                    for (String strParam : strParams.split("\\s+")) {
                        affineTransformParameterArr.add(Double.valueOf(strParam));
                    }
                    double[] affineTransformParameter = new double[affineTransformParameterArr.size()];
                    int idx = 0;
                    Iterator<Object> i$ = affineTransformParameterArr.iterator();
                    while (i$.hasNext()) {
                        double aaffineItem = (Double)i$.next();
                        affineTransformParameter[idx++] = aaffineItem;
                    }
                    partsSet.setAffineTransformParameter(affineTransformParameter);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "affine transform parameter is invalid. :" + strParams, ex);
                }
            }
            for (Node nodeCategory : this.iterable((NodeList)expCategories.evaluate(nodePreset, XPathConstants.NODESET))) {
                String categoryId = ((Node)expRefId.evaluate(nodeCategory, XPathConstants.NODE)).getTextContent().trim();
                PartsCategory category = characterData.getPartsCategory(categoryId);
                if (category == null) {
                    logger.log(Level.WARNING, "undefined category: " + categoryId);
                    continue;
                }
                for (Node nodeParts : this.iterable((NodeList)expParts.evaluate(nodeCategory, XPathConstants.NODESET))) {
                    String partsName = ((Node)expName.evaluate(nodeParts, XPathConstants.NODE)).getTextContent().trim();
                    PartsIdentifier partsIdentifier = new PartsIdentifier(category, partsName, partsName);
                    AbstractMap partsColorInfo = null;
                    for (Node nodeLayer : this.iterable((NodeList)expLayers.evaluate(nodeParts, XPathConstants.NODESET))) {
                        Element elmRgbReplace;
                        String layerId = ((Node)expRefId.evaluate(nodeLayer, XPathConstants.NODE)).getTextContent().trim();
                        Layer layer = category.getLayer(layerId);
                        if (layer == null) {
                            logger.log(Level.WARNING, "undefined layer: " + layerId);
                            continue;
                        }
                        if (partsColorInfo == null) {
                            partsColorInfo = new PartsColorInfo(category);
                        }
                        ColorInfo colorInfo = (ColorInfo)partsColorInfo.get(layer);
                        Element elmColorGroup = (Element)expColorGroup.evaluate(nodeLayer, XPathConstants.NODE);
                        if (elmColorGroup != null) {
                            ColorGroup colorGroup = characterData.getColorGroup(elmColorGroup.getAttribute("group"));
                            boolean syncColorGroup = Boolean.parseBoolean(elmColorGroup.getAttribute("synchronized"));
                            colorInfo.setColorGroup(colorGroup);
                            colorInfo.setSyncColorGroup(syncColorGroup);
                        }
                        ColorConvertParameter param = colorInfo.getColorParameter();
                        for (Node nodeRgb : this.iterable((NodeList)expRgb.evaluate(nodeLayer, XPathConstants.NODESET))) {
                            Element elmRgb = (Element)nodeRgb;
                            String rgbName = elmRgb.getNodeName();
                            int offset = Integer.parseInt(elmRgb.getAttribute("offset"));
                            float factor = Float.parseFloat(elmRgb.getAttribute("factor"));
                            float gamma = Float.parseFloat(elmRgb.getAttribute("gamma"));
                            if ("red".equals(rgbName)) {
                                param.setOffsetR(offset);
                                param.setFactorR(factor);
                                param.setGammaR(gamma);
                                continue;
                            }
                            if ("green".equals(rgbName)) {
                                param.setOffsetG(offset);
                                param.setFactorG(factor);
                                param.setGammaG(gamma);
                                continue;
                            }
                            if ("blue".equals(rgbName)) {
                                param.setOffsetB(offset);
                                param.setFactorB(factor);
                                param.setGammaB(gamma);
                                continue;
                            }
                            if (!"alpha".equals(rgbName)) continue;
                            param.setOffsetA(offset);
                            param.setFactorA(factor);
                            param.setGammaA(gamma);
                        }
                        Element elmHsb = (Element)expHsb.evaluate(nodeLayer, XPathConstants.NODE);
                        if (elmHsb != null) {
                            float hue = Float.parseFloat(elmHsb.getAttribute("hue"));
                            float saturation = Float.parseFloat(elmHsb.getAttribute("saturation"));
                            float brightness = Float.parseFloat(elmHsb.getAttribute("brightness"));
                            param.setHue(hue);
                            param.setSaturation(saturation);
                            param.setBrightness(brightness);
                        }
                        if ((elmRgbReplace = (Element)expRgbReplace.evaluate(nodeLayer, XPathConstants.NODE)) == null) continue;
                        Float grayLevel = Float.valueOf(Float.parseFloat(elmRgbReplace.getAttribute("gray")));
                        ColorConv colorType = ColorConv.valueOf(elmRgbReplace.getAttribute("replace-type"));
                        param.setGrayLevel(grayLevel.floatValue());
                        param.setColorReplace(colorType);
                    }
                    partsSet.appendParts(category, partsIdentifier, (PartsColorInfo)partsColorInfo);
                }
            }
            characterData.addPartsSet(partsSet);
        }
        if (presetParts) {
            characterData.setDefaultPartsSetId(defaultPresetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFavorites(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserData favoritesSer = this.getFavoritesUserData(characterData, "ser");
        UserData favoritesData = this.getFavoritesUserData(characterData, "xml");
        try {
            if (favoritesSer.exists() && favoritesSer.lastModified() >= favoritesData.lastModified()) {
                Collection partsSets = (Collection)favoritesSer.load();
                for (PartsSet partsSet : partsSets) {
                    characterData.addPartsSet(partsSet);
                }
                return;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "cached favorites loading failed. :" + characterData, ex);
        }
        if (favoritesData.exists()) {
            DocInfo docInfo;
            InputStream is = favoritesData.openStream();
            try {
                docInfo = this.readDocumentType(is);
            }
            finally {
                is.close();
            }
            if (docInfo == null) {
                throw new IOException("unknown document type :" + characterData);
            }
            is = favoritesData.openStream();
            try {
                this.loadPartsSet(characterData, is, docInfo);
            }
            finally {
                is.close();
            }
        }
        try {
            Collection<PartsSet> partsSetsOrg = characterData.getPartsSets().values();
            ArrayList<PartsSet> partsSets = new ArrayList<PartsSet>(partsSetsOrg);
            favoritesSer.save(partsSets);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "cached favorites creation failed. :" + characterData, ex);
        }
    }

    protected void loadPartsSet(CharacterData characterData, InputStream inpstm, DocInfo docInfo) throws IOException {
        Document doc;
        if (characterData == null || inpstm == null || docInfo == null) {
            throw new IllegalArgumentException();
        }
        Schema schema = this.loadSchema(docInfo);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setSchema(schema);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            final ArrayList errors = new ArrayList();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }

                public void warning(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }
            });
            doc = builder.parse(inpstm);
            if (errors.size() > 0) {
                throw (SAXParseException)errors.get(0);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        catch (SAXException ex) {
            IOException ex2 = new IOException("PartsSet invalid format");
            ex2.initCause(ex);
            throw ex2;
        }
        try {
            XPath xpath = this.createXPath(docInfo);
            Node nodePartssets = (Node)xpath.evaluate("/pre:partssets", doc, XPathConstants.NODE);
            if (nodePartssets != null) {
                this.loadPartsSet(characterData, nodePartssets, false, docInfo);
            }
        }
        catch (XPathExpressionException ex) {
            IOException ex2 = new IOException("PartsSet invalid format");
            ex2.initCause(ex2);
            throw ex2;
        }
    }

    public void remove(CharacterData cd, boolean forceRemove) throws IOException {
        UserData[] favoritesDatas;
        if (cd == null || cd.getDocBase() == null) {
            throw new IllegalArgumentException();
        }
        URI docBase = cd.getDocBase();
        File xmlFile = new File(docBase);
        if (!xmlFile.exists() || !xmlFile.isFile()) {
            return;
        }
        UserData serializedFile = this.getCharacterDataCacheUserFile(docBase);
        if (serializedFile.exists()) {
            logger.log(Level.INFO, "remove file: " + serializedFile);
            serializedFile.delete();
        }
        for (UserData favoriteData : favoritesDatas = new UserData[]{!forceRemove ? null : this.getFavoritesUserData(cd, "xml"), this.getFavoritesUserData(cd, "ser")}) {
            if (favoriteData == null || !favoriteData.exists()) continue;
            logger.log(Level.INFO, "remove file: " + favoriteData);
            favoriteData.delete();
        }
        UserData workingSetSer = MainFrame.getWorkingSetUserData(cd, true);
        if (workingSetSer != null && workingSetSer.exists()) {
            logger.log(Level.INFO, "remove file: " + workingSetSer);
            workingSetSer.delete();
        }
        String suffix = "." + System.currentTimeMillis() + ".deleted";
        File bakFile = new File(xmlFile.getPath() + suffix);
        if (!xmlFile.renameTo(bakFile)) {
            throw new IOException("can not rename configuration file.:" + xmlFile);
        }
        File baseDir = xmlFile.getParentFile();
        if (!forceRemove) {
            File parentBak = new File(baseDir.getPath() + suffix);
            if (!baseDir.renameTo(parentBak)) {
                throw new IOException("can't rename directory. " + baseDir);
            }
        } else {
            this.removeRecursive(baseDir);
        }
    }

    protected void removeRecursive(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.removeRecursive(child);
            }
        }
        if (!file.delete()) {
            throw new IOException("can't delete file. " + file);
        }
    }

    protected Iterable<Node> iterable(final NodeList nodeList) {
        final int mx = nodeList == null ? 0 : nodeList.getLength();
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < mx;
                    }

                    @Override
                    public Node next() {
                        if (this.idx >= mx) {
                            throw new NoSuchElementException();
                        }
                        return nodeList.item(this.idx++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    protected Schema loadSchema(DocInfo docInfo) throws IOException {
        if (docInfo == null) {
            throw new IllegalArgumentException();
        }
        String schemaName = null;
        if ("character".equals(docInfo.getFirstElementName())) {
            if ("http://com.exmaple/charactermanaj".equals(docInfo.getNamespace())) {
                schemaName = CHARACTER_XML_SCHEMA_0_8;
            } else if (NS.equals(docInfo.getNamespace())) {
                schemaName = CHARACTER_XML_SCHEMA;
            }
        } else if ("partssets".equals(docInfo.getFirstElementName())) {
            if ("http://com.exmaple/charactermanaj".equals(docInfo.getNamespace())) {
                schemaName = PARTSSET_XML_SCHEMA_0_8;
            } else if (NS.equals(docInfo.getNamespace())) {
                schemaName = PARTSSET_XML_SCHEMA;
            }
        }
        if (schemaName == null) {
            throw new IOException("unsupported namespace: " + docInfo);
        }
        Schema schema = this.schemaMap.get(schemaName);
        if (schema != null) {
            return schema;
        }
        URL schemaURL = null;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(errorHandler);
            schemaURL = this.getSchemaURL(schemaName);
            schema = schemaFactory.newSchema(schemaURL);
            this.schemaMap.put(schemaName, schema);
            return schema;
        }
        catch (Exception ex) {
            throw new RuntimeException("schema creation failed. :" + schemaURL, ex);
        }
    }

    protected URL getSchemaURL(String schemaName) {
        return this.getClass().getResource(schemaName);
    }

    protected XPath createXPath(DocInfo docInfo) {
        if (docInfo == null) {
            throw new IllegalArgumentException();
        }
        final String namespace = docInfo.getNamespace() != null && docInfo.getNamespace().length() > 0 ? docInfo.getNamespace() : NS;
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new IllegalArgumentException();
                }
                if (prefix.equals("pre")) {
                    return namespace;
                }
                if (prefix.equals("xml")) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                return "";
            }

            public Iterator<?> getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException();
            }
        });
        return xpath;
    }

    public BufferedImage loadSamplePicture(CharacterData characterData, ImageLoader loader) throws IOException {
        if (characterData == null || loader == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.isValid()) {
            return null;
        }
        File sampleImageFile = this.getSamplePictureFile(characterData);
        if (sampleImageFile != null && sampleImageFile.exists()) {
            LoadedImage loadedImage = loader.load(new FileImageResource(sampleImageFile));
            return loadedImage.getImage();
        }
        return null;
    }

    public boolean canSaveSamplePicture(CharacterData characterData) {
        if (characterData == null || !characterData.isValid()) {
            return false;
        }
        File sampleImageFile = this.getSamplePictureFile(characterData);
        if (sampleImageFile != null) {
            File parentDir;
            if (sampleImageFile.exists() && sampleImageFile.canWrite()) {
                return true;
            }
            if (!sampleImageFile.exists() && (parentDir = sampleImageFile.getParentFile()) != null) {
                return parentDir.canWrite();
            }
        }
        return false;
    }

    protected File getSamplePictureFile(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        URI docBase = characterData.getDocBase();
        if (docBase != null && "file".endsWith(docBase.getScheme())) {
            File docBaseFile = new File(docBase);
            return new File(docBaseFile.getParentFile(), SAMPLE_IMAGE_FILENAME);
        }
        return null;
    }

    public void saveSamplePicture(CharacterData characterData, BufferedImage samplePicture) throws IOException {
        if (!this.canSaveSamplePicture(characterData)) {
            throw new IOException("can not write a sample picture.:" + characterData);
        }
        File sampleImageFile = this.getSamplePictureFile(characterData);
        if (samplePicture != null) {
            AppConfig appConfig = AppConfig.getInstance();
            Color sampleImageBgColor = appConfig.getSampleImageBgColor();
            ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
            imageSaveHelper.savePicture(samplePicture, sampleImageBgColor, sampleImageFile, null);
        } else if (sampleImageFile.exists() && !sampleImageFile.delete()) {
            throw new IOException("sample pucture delete failed. :" + sampleImageFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePartsManageData(URI docBase, PartsManageData partsManageData) throws IOException {
        if (docBase == null || partsManageData == null) {
            throw new IllegalArgumentException();
        }
        if (!"file".equals(docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093: " + docBase);
        }
        File docBaseFile = new File(docBase);
        File baseDir = docBaseFile.getParentFile();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.savePartsManageData(partsManageData, bos);
        }
        finally {
            bos.close();
        }
        File partsInfoXML = new File(baseDir, "parts-info.xml");
        FileOutputStream os = new FileOutputStream(partsInfoXML);
        try {
            os.write(bos.toByteArray());
        }
        finally {
            os.close();
        }
    }

    public void savePartsManageData(PartsManageData partsManageData, OutputStream outstm) throws IOException {
        Transformer tfmr;
        Document doc;
        if (partsManageData == null || outstm == null) {
            throw new IllegalArgumentException();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Exception.", ex);
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        Element root = doc.createElementNS(NS_PARTSDEF, "parts-definition");
        root.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://charactermanaj.sourceforge.jp/schema/charactermanaj-partsdef parts-definition.xsd");
        doc.appendChild(root);
        Collection<PartsAuthorInfo> partsAuthors = partsManageData.getAuthorInfos();
        for (PartsAuthorInfo partsAuthorInfo : partsAuthors) {
            String author = partsAuthorInfo.getAuthor();
            if (author == null || author.length() == 0) continue;
            Element nodeAuthor = doc.createElementNS(NS_PARTSDEF, "author");
            Element nodeAuthorName = doc.createElementNS(NS_PARTSDEF, "name");
            Attr attrLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
            attrLang.setValue(lang);
            nodeAuthorName.setAttributeNodeNS(attrLang);
            nodeAuthorName.setTextContent(author);
            nodeAuthor.appendChild(nodeAuthorName);
            String homepageURL = partsAuthorInfo.getHomePage();
            if (homepageURL != null && homepageURL.length() > 0) {
                Element nodeHomepage = doc.createElementNS(NS_PARTSDEF, "home-page");
                Attr attrHomepageLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrHomepageLang.setValue(lang);
                nodeHomepage.setAttributeNodeNS(attrHomepageLang);
                nodeHomepage.setTextContent(homepageURL);
                nodeAuthor.appendChild(nodeHomepage);
            }
            root.appendChild(nodeAuthor);
            Collection<PartsManageData.PartsKey> partsKeys = partsManageData.getPartsKeysByAuthor(author);
            HashMap<String, ArrayList<PartsManageData.PartsKey>> downloadMap = new HashMap<String, ArrayList<PartsManageData.PartsKey>>();
            for (PartsManageData.PartsKey partsKey : partsKeys) {
                ArrayList<PartsManageData.PartsKey> partsKeyGrp;
                PartsManageData.PartsVersionInfo versionInfo = partsManageData.getVersionStrict(partsKey);
                String downloadURL = versionInfo.getDownloadURL();
                if (downloadURL == null) {
                    downloadURL = "";
                }
                if ((partsKeyGrp = (ArrayList<PartsManageData.PartsKey>)downloadMap.get(downloadURL)) == null) {
                    partsKeyGrp = new ArrayList<PartsManageData.PartsKey>();
                    downloadMap.put(downloadURL, partsKeyGrp);
                }
                partsKeyGrp.add(partsKey);
            }
            ArrayList downloadURLs = new ArrayList(downloadMap.keySet());
            Collections.sort(downloadURLs);
            for (String downloadURL : downloadURLs) {
                List partsKeyGrp = (List)downloadMap.get(downloadURL);
                Collections.sort(partsKeyGrp);
                Element nodeDownload = doc.createElementNS(NS_PARTSDEF, "download-url");
                nodeDownload.setTextContent(downloadURL);
                root.appendChild(nodeDownload);
                for (PartsManageData.PartsKey partsKey : partsKeyGrp) {
                    String localizedName;
                    PartsManageData.PartsVersionInfo versionInfo = partsManageData.getVersionStrict(partsKey);
                    Element nodeParts = doc.createElementNS(NS_PARTSDEF, "parts");
                    nodeParts.setAttribute("name", partsKey.getPartsName());
                    if (partsKey.getCategoryId() != null) {
                        nodeParts.setAttribute("category", partsKey.getCategoryId());
                    }
                    if (versionInfo.getVersion() > 0.0) {
                        nodeParts.setAttribute("version", Double.toString(versionInfo.getVersion()));
                    }
                    if ((localizedName = partsManageData.getLocalizedName(partsKey)) != null && localizedName.trim().length() > 0) {
                        Element nodeLocalizedName = doc.createElementNS(NS_PARTSDEF, "local-name");
                        Attr attrLocalizedNameLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                        attrLocalizedNameLang.setValue(lang);
                        nodeLocalizedName.setAttributeNodeNS(attrLocalizedNameLang);
                        nodeLocalizedName.setTextContent(localizedName);
                        nodeParts.appendChild(nodeLocalizedName);
                    }
                    root.appendChild(nodeParts);
                }
            }
        }
        TransformerFactory txFactory = TransformerFactory.newInstance();
        txFactory.setAttribute("indent-number", 4);
        try {
            tfmr = txFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        tfmr.setOutputProperty("indent", "yes");
        String encoding = "UTF-8";
        tfmr.setOutputProperty("encoding", "UTF-8");
        try {
            tfmr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(outstm, Charset.forName("UTF-8"))));
        }
        catch (TransformerException ex) {
            IOException ex2 = new IOException("XML Convert failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartsManageData loadPartsManageData(URI docBase) throws IOException {
        PartsManageData partsManageData;
        if (docBase == null) {
            throw new IllegalArgumentException();
        }
        if (!"file".equals(docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002:" + docBase);
        }
        File docBaseFile = new File(docBase);
        File baseDir = docBaseFile.getParentFile();
        File partsInfoXML = new File(baseDir, "parts-info.xml");
        if (!partsInfoXML.exists()) {
            return new PartsManageData();
        }
        FileInputStream is = new FileInputStream(partsInfoXML);
        try {
            partsManageData = this.loadPartsManageData(is);
        }
        finally {
            ((InputStream)is).close();
        }
        return partsManageData;
    }

    public PartsManageData loadPartsManageData(InputStream is) throws IOException {
        SAXParser saxParser;
        if (is == null) {
            throw new IllegalArgumentException();
        }
        final PartsManageData partsManageData = new PartsManageData();
        try {
            SAXParserFactory saxPartserFactory = SAXParserFactory.newInstance();
            saxPartserFactory.setNamespaceAware(true);
            saxParser = saxPartserFactory.newSAXParser();
        }
        catch (Exception ex) {
            throw new RuntimeException("JAXP Configuration failed.", ex);
        }
        Locale locale = Locale.getDefault();
        final String lang = locale.getLanguage();
        try {
            final LinkedList stack = new LinkedList();
            saxParser.parse(is, new DefaultHandler(){
                private StringBuilder buf = new StringBuilder();
                private PartsAuthorInfo partsAuthorInfo;
                private String authorName;
                private String homepageURL;
                private String authorNameLang;
                private String homepageLang;
                private String downloadURL;
                private String partsLocalNameLang;
                private String partsLocalName;
                private String partsCategoryId;
                private String partsName;
                private double partsVersion;

                public void startDocument() throws SAXException {
                    logger.log(Level.FINEST, "parts-info : start");
                }

                public void endDocument() throws SAXException {
                    logger.log(Level.FINEST, "parts-info : end");
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.buf.append(ch, start, length);
                }

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    stack.addFirst(qName);
                    int mx = stack.size();
                    if (mx >= 2 && ((String)stack.get(1)).equals("parts")) {
                        if ("local-name".equals(qName)) {
                            this.partsLocalNameLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                        }
                    } else if (mx >= 2 && ((String)stack.get(1)).equals("author")) {
                        if ("name".equals(qName)) {
                            this.authorNameLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                        } else if ("home-page".equals(qName)) {
                            this.homepageLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                        }
                    } else if ("author".equals(qName)) {
                        this.partsAuthorInfo = null;
                        this.authorName = null;
                        this.authorNameLang = null;
                        this.homepageURL = null;
                        this.homepageLang = null;
                    } else if ("download-url".equals(qName)) {
                        this.downloadURL = null;
                    } else if ("parts".equals(qName)) {
                        this.partsLocalName = null;
                        this.partsLocalNameLang = null;
                        this.partsCategoryId = attributes.getValue("category");
                        this.partsName = attributes.getValue("name");
                        String strVersion = attributes.getValue("version");
                        try {
                            if (strVersion == null || strVersion.length() == 0) {
                                this.partsVersion = 0.0;
                            } else {
                                this.partsVersion = Double.parseDouble(strVersion);
                                if (this.partsVersion < 0.0) {
                                    this.partsVersion = 0.0;
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, "parts-info.xml: invalid version." + strVersion);
                            this.partsVersion = 0.0;
                        }
                    }
                    this.buf = new StringBuilder();
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    int mx = stack.size();
                    if (mx >= 2 && "parts".equals(stack.get(1))) {
                        if ("local-name".equals(qName) && (this.partsLocalName == null || lang.equals(this.partsLocalNameLang))) {
                            this.partsLocalName = this.buf.toString();
                        }
                    } else if (mx >= 2 && "author".equals(stack.get(1))) {
                        if ("name".equals(qName)) {
                            if (this.authorName == null || lang.equals(this.authorNameLang)) {
                                this.authorName = this.buf.toString();
                            }
                        } else if ("home-page".equals(qName) && (this.homepageURL == null || lang.equals(this.homepageLang))) {
                            this.homepageURL = this.buf.toString();
                        }
                    } else if ("author".equals(qName)) {
                        logger.log(Level.FINE, "parts-info: author: " + this.authorName + " /homepage:" + this.homepageURL);
                        if (this.authorName != null && this.authorName.length() > 0) {
                            this.partsAuthorInfo = new PartsAuthorInfo();
                            this.partsAuthorInfo.setAuthor(this.authorName);
                            this.partsAuthorInfo.setHomePage(this.homepageURL);
                        } else {
                            this.partsAuthorInfo = null;
                        }
                    } else if ("download-url".equals(qName)) {
                        this.downloadURL = this.buf.toString();
                        logger.log(Level.FINE, "parts-info: download-url: " + this.downloadURL);
                    } else if ("parts".equals(qName)) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "parts-info.xml: parts-name: " + this.partsName + " /category: " + this.partsCategoryId + " /parts-local-name: " + this.partsLocalName + " /version:" + this.partsVersion);
                        }
                        PartsManageData.PartsVersionInfo versionInfo = new PartsManageData.PartsVersionInfo();
                        versionInfo.setVersion(this.partsVersion);
                        versionInfo.setDownloadURL(this.downloadURL);
                        PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(this.partsName, this.partsCategoryId);
                        partsManageData.putPartsInfo(partsKey, this.partsLocalName, this.partsAuthorInfo, versionInfo);
                    }
                    stack.removeFirst();
                }
            });
        }
        catch (SAXException ex) {
            IOException ex2 = new IOException("parts-info.xml read failed.");
            ex2.initCause(ex);
            throw ex2;
        }
        return partsManageData;
    }

    public static interface ProfileListErrorHandler {
        public void occureException(File var1, Throwable var2);
    }

    public static class DocInfo {
        private String firstElementName;
        private String version;
        private String namespace;

        public void setFirstElementName(String firstElementName) {
            this.firstElementName = firstElementName;
        }

        public String getFirstElementName() {
            return this.firstElementName;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return this.firstElementName + " /version: " + this.version + " /namespace:" + this.namespace;
        }
    }
}

