/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ErrorMessageHelper;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DesktopUtilities {
    private static final Logger logger = Logger.getLogger(DesktopUtilities.class.getName());
    private static Object desktopObj;
    private static Method methodBrowse;
    private static Method methodEdit;
    private static Method methodOpen;

    private DesktopUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static boolean isSupported() {
        return desktopObj != null;
    }

    protected static boolean callMethod(Method method, Object arg) throws IOException {
        if (desktopObj == null) {
            return false;
        }
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "invoke: " + method + "/arg=" + arg);
            }
            method.invoke(desktopObj, arg);
            return true;
        }
        catch (InvocationTargetException ex) {
            Throwable iex = ex.getCause();
            if (iex != null && iex instanceof IOException) {
                throw (IOException)iex;
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean browse(URI uri) throws IOException {
        return DesktopUtilities.callMethod(methodBrowse, uri);
    }

    public static boolean browseBaseDir(URI docBase) throws IOException {
        File baseDir = null;
        try {
            if (docBase != null) {
                baseDir = new File(docBase).getParentFile();
            }
        }
        catch (Exception ex) {
            baseDir = null;
        }
        if (baseDir == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return false;
        }
        return DesktopUtilities.open(baseDir);
    }

    public static boolean edit(File file) throws IOException {
        return DesktopUtilities.callMethod(methodEdit, file);
    }

    public static boolean open(File file) throws IOException {
        return DesktopUtilities.callMethod(methodOpen, file);
    }

    public static void browse(Component parent, String url, String description) {
        try {
            URI helpURI = new URI(url);
            if (!DesktopUtilities.browse(helpURI)) {
                JPanel panel = new JPanel();
                BoxLayout layout = new BoxLayout(panel, 1);
                panel.setLayout(layout);
                panel.add(new JLabel(description));
                JTextField txtURL = new JTextField(url);
                panel.add(txtURL);
                JOptionPane.showMessageDialog(parent, panel);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(parent, ex);
        }
    }

    public static ActionListener createBrowseAction(final Component parent, final String url, final String description) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DesktopUtilities.browse(parent, url, description);
            }
        };
    }

    static {
        try {
            Class<?> clz = Class.forName("java.awt.Desktop");
            Method mtdGetDesktop = clz.getMethod("getDesktop", new Class[0]);
            methodBrowse = clz.getMethod("browse", URI.class);
            methodEdit = clz.getMethod("edit", File.class);
            methodOpen = clz.getMethod("open", File.class);
            desktopObj = mtdGetDesktop.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.CONFIG, "AWT Desktop is not suuported.");
            desktopObj = null;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "AWT Desktop failed.", ex);
            desktopObj = null;
        }
    }
}

