/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authn.saml2.web;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.DataUtil;
import jp.co.ogis_ri.citk.common.NameIDCache;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.http.HttpConnector;

/**
 * Mule ESBの認証Cookie確認用カスタムフィルタークラス実装。
 *
 * @author toyota
 *
 */
public class AccessFilter implements Filter {
    /**
     * ログメッセージ出力用オブジェクト。
     */
	private static final CitkLogger logger = CitkLogger.getLog(AccessFilter.class);
    
    /**
     * ログイン済みユーザの情報を収めたキャッシュ。
     * @see NameIDCache
     */
    private NameIDCache cache = null;
    
	/**
     * cacheのgetter。
     * mule-global-config.xmlにてSpringBeanとして使用している。
     *
     * @return NameIDCache
     */
    public NameIDCache getCache() {
        return cache;
    }

    /**
     * cacheのsetter。
     *
     * @see #getCache
     * @param cache
     */
    public void setCache(NameIDCache cache) {
        this.cache = cache;
    }    

    @Override
    /**
     * 認証済みかどうか判定するMuleのフィルタメソッド。
     *
     * @param message 判定対象となるMuleMessage
     * @return boolean true:認証済み、false:未認証
     */
    public boolean accept(MuleMessage message) {
    	
    	 String nameId = DataUtil.getCookieValue(
                 message.getInboundProperty(HttpConnector.HTTP_COOKIES_PROPERTY), CitkConstants.NAMEID_KEY);
         
         if (nameId == null || nameId.isEmpty()) {
             logger.info(CitkConstants.LOG_MSG_NOT_CONTAIN_NAMEID_COOKIE);
             return false;
         }
         else{
        	 String value = cache.get(nameId);
        	 if (value == null || value.isEmpty()) {
        		 logger.info(CitkConstants.LOG_MSG_NOT_CONTAIN_NAMEID_COOKIE);
                 return false;
             }
        	 logger.info(CitkConstants.LOG_MSG_NAMEID_COOKIE, nameId);
        	 //Todo:valueの値は何にするか？どのように正当性の確認を行うか。
         }
         
         //IdPEntityIDのCookieの有無
         String idpEntityId = DataUtil.getCookieValue(
                 message.getInboundProperty(HttpConnector.HTTP_COOKIES_PROPERTY), CitkConstants.IDP_ENTITYID_KEY);
         if (idpEntityId == null || idpEntityId.isEmpty()) {
        	 logger.info(CitkConstants.LOG_MSG_NOT_CONTAIN_IDPENTITYID_COOKIE);
             return false;
         }
         logger.info(CitkConstants.LOG_MSG_IDPENTITYID_COOKIE, idpEntityId);
         
         
         // 認可の有無
         if("false".equalsIgnoreCase((String)message.getInboundProperty(CitkConstants.AUTHZ_REQUEST_PARAM))){
             message.setProperty(CitkConstants.AUTHZ_REQUEST_PARAM, "false", PropertyScope.OUTBOUND);
             logger.info(CitkConstants.LOG_MSG_REQUEST_NOT_AUTHORIZATION);
         }
         else{
        	 message.setSessionProperty(CitkConstants.NAMEID_KEY, nameId.replace("/", "%2F"));
         }
         
         return true;
    }
}