/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authn.saml2.web;

import java.util.Date;
import java.util.TimeZone;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.http.HttpConstants;
import org.apache.commons.httpclient.Cookie;
import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.log.exception.CitkSystemException;

/**
 * Mule ESBの認証Cookie発行用トランスフォーマ実装。
 *
 * @author ISP Shiraishi
 *
 */
public class AuthnSetCookiesTransformer extends AbstractMessageTransformer {

    /**
     * カスタムトランスフォーマーのコンストラクタ。
     */
	public AuthnSetCookiesTransformer(){
		super();
	}
	
    /**
     * ログメッセージ出力用オブジェクト。
     */
//	private static final CitkLogger logger = CitkLogger.getLog(AccessFilter.class);
	
	/**
     * 発行cookieのタイムゾーン
     */
	private String timezone = null;
	
	/**
     * 発行cookieの、発行時刻からexpireまでの間隔（ミリ秒）
     */
	private long expire = 0;
	
	/**
     * 発行cookieのドメイン
     */
	private String domain = null;
	
	
	/**
	 * @return timezone
	 */
	public String getTimezone() {
		return timezone;
	}

	/**
	 * @param timezone セットする timezone
	 */
	public void setTimezone(String timezone) {
		this.timezone = timezone;
	}

	/**
	 * @return expire
	 */
	public long getExpire() {
		return expire;
	}

	/**
	 * @param expire セットする expire
	 */
	public void setExpire(long expire) {
		this.expire = expire;
	}

	/**
	 * @return domain
	 */
	public String getDomain() {
		return domain;
	}

	/**
	 * @param domain セットする domain
	 */
	public void setDomain(String domain) {
		this.domain = domain;
	}

	@Override
	/**
     * 認証判定用のCookieをセットするMuleのトランスフォーマメソッド。
     *
     * @param message 変換対象のMuleMessageオブジェクト
     * @param outputEncoding エンコード
     * @return 変換後のMuleMessageオブジェクト
     */
	public MuleMessage transformMessage(MuleMessage message, String outputEncoding)
			throws TransformerException {

        TimeZone.setDefault(TimeZone.getTimeZone(timezone));
        
        Date date = new Date();
        Date expireDate = new Date(date.getTime() + expire); 

        String nameId = message.getSessionProperty(CitkConstants.NAMEID_KEY);
                
        if(nameId == null){
        	throw new CitkSystemException(CitkConstants.ERROR_MSG_NAMEID_IS_NULL);
        }
        
        String idpEntityId = message.getSessionProperty(CitkConstants.IDP_ENTITYID_KEY);
        
        if(idpEntityId == null){
        	throw new CitkSystemException(CitkConstants.ERROR_MSG_IDPENTITYID_IS_NULL);
        }
        
        Cookie[] cookies = new Cookie[2];
        cookies[0] = createCookie(domain, CitkConstants.NAMEID_KEY, nameId, expireDate);
	    cookies[1] = createCookie(domain, CitkConstants.IDP_ENTITYID_KEY, idpEntityId, expireDate);
	    
        message.setProperty(HttpConstants.HEADER_COOKIE_SET, cookies,
                PropertyScope.INBOUND);

        return message;
    }

	/**
     * Cookieを生成するメソッド
     *
     * @param domain ドメイン
     * @param cookieName 名称
     * @param value 値
     * @param expires 有効期限
     * @return 生成したcookie
     */
    private Cookie createCookie(String domain, String cookieName, String value,
            Date expires){
        return new Cookie(domain, cookieName, value, "/", expires, false);
    }
}
