/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authn.saml2.web;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.RequestParameterCache;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.log.exception.CitkSystemException;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;


/**
 * Mule ESBのリダイレクト処理トランスフォーマークラス実装。
 * @author ISP Shiraishi
 *
 */
public class RedirectionTransformer extends AbstractMessageTransformer {
	
    /**
     * カスタムトランスフォーマーのコンストラクタ。
     */
    public RedirectionTransformer() {
        super();
    }
	
    /**
     * ログメッセージ出力用オブジェクト。
     */
//    private static final CitkLogger logger =　CitkLogger.getLog(RedirectionTransformer.class);
    
    /**
     * リクエストプロトコル。
     */
	private String requestProtocol = null;
	
    /**
	 * @return requestProtocol
	 */
	public String getRequestProtocol() {
		return requestProtocol;
	}

	/**
	 * @param requestProtocol セットする requestProtocol
	 */
	public void setRequestProtocol(String requestProtocol) {
		this.requestProtocol = requestProtocol;
	}

	/**
     * リクエストMuleMessgaeを収めたキャッシュ。
     * @see RequestParameterCache
     */
    private RequestParameterCache cache = null;

    /**
     * cacheのgetter。
     * mule-global-config.xmlにてSpringBeanとして使用している。
     *
     * @return SubjectCache
     */
    public RequestParameterCache getCache() {
        return cache;
    }

    /**
     * cacheのsetter。
     *
     * @see #getCache
     * @param cache
     */
    public void setCache(RequestParameterCache cache) {
        this.cache = cache;
    }

	@Override
    /**
     * リダイレクト処理を行う。
     * @param message 変換対象のMuleMessageオブジェクト
     * @param outputEncoding エンコード
     * @return 変換後のMuleMessageオブジェクト
     * @throws TransformerException
     */
    public Object transformMessage(MuleMessage message, String outputEncoding)
                                                   throws TransformerException {

    	String acsStatus = message.getOutboundProperty(CitkConstants.CITK_ACS_STATUS_KEY);
		String location = null;

		if (acsStatus == null) {
			location = message.getInboundProperty(HttpConstants.HEADER_LOCATION);
		}
		else if (acsStatus.equals(CitkConstants.CITK_ACS_STATUS_OK)) {
			
			//RelayStateをリダイレクトのGetパラメータとして付与
			String relayState = message.getSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY);

			MuleMessage originalMessage = cache.get(relayState);
			
			String host = originalMessage.getInboundProperty(HttpConstants.HEADER_HOST);
			String path = originalMessage.getInboundProperty(HttpConnector.HTTP_REQUEST_PATH_PROPERTY);
			
			location = this.requestProtocol + host + path + "?" + CitkConstants.RELAYSTATE_PARAM + "=" + relayState;

		}
		else if (acsStatus.equals(CitkConstants.CITK_ACS_STATUS_NG)) {
			location = message.getInboundProperty(HttpConstants.HEADER_LOCATION);
						
			String RelayState = message.getSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY);

			if(location.contains("?")){
				location = location + "&" + CitkConstants.RELAYSTATE_PARAM + "=" + RelayState;				
			}
			else{
				location = location + "?" + CitkConstants.RELAYSTATE_PARAM + "=" + RelayState;
			}
		}
		else {
			throw new CitkSystemException(CitkConstants.ERROR_MSG_INVALID_ACSSTATUS);
		}
		
		if (location != null) {
			message.setOutboundProperty(HttpConnector.HTTP_STATUS_PROPERTY, HttpConstants.SC_MOVED_TEMPORARILY);
			message.setOutboundProperty(HttpConstants.HEADER_LOCATION, location);
		}
		else{
			//TODO Exception時の情報に何を含めるか検討
			throw new CitkSystemException(CitkConstants.ERROR_MSG_LOCATION_IS_NULL);
		}

		return message;
    }
}
