/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authn.saml2.web;

import java.util.UUID;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;

import org.mule.transformer.AbstractMessageTransformer;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.RequestParameterCache;
import jp.co.ogis_ri.citk.common.log.CitkLogger;


/**
 * Mule ESBのリクエストメッセ時キャッシュ用トランスフォーマークラス実装。
 * @author ISP Shiraishi
 *
 */
public class RequestCacheTransformer extends AbstractMessageTransformer {
	
    /**
     * カスタムトランスフォーマーのコンストラクタ。
     */
    public RequestCacheTransformer() {
        super();
    }
    
    /**
     * ログメッセージ出力用オブジェクト。
     */
    private static final CitkLogger logger =
    		CitkLogger.getLog(RequestCacheTransformer.class);
    
    /**
     * リクエストMuleMessgaeを収めたキャッシュ。
     * @see RequestParameterCache
     */
    private RequestParameterCache cache = null;
    
    /**
     * cacheのgetter。
     * mule-global-config.xmlにてSpringBeanとして使用している。
     *
     * @return RequestParameterCache
     */
    public RequestParameterCache getCache() {
        return cache;
    }

    /**
     * cacheのsetter。
     *
     * @see #getCache
     * @param cache
     */
    public void setCache(RequestParameterCache cache) {
        this.cache = cache;
    }
       


    @Override
    /**
     * 認証前のリクエストパラメータをキャッシュに保持する。
     * @param message 変換対象のMuleMessageオブジェクト
     * @param outputEncoding エンコード
     * @return 変換後のMuleMessageオブジェクト
     * @throws TransformerException
     */
    public MuleMessage transformMessage(MuleMessage message, String outputEncoding)
                                                   throws TransformerException { 	
    	
    	String relayState = UUID.randomUUID().toString();

		message.setSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY, relayState);
    	
    	cache.add(relayState, message);
    	
    	logger.info(CitkConstants.LOG_MSG_CREATE_RELAYSTATE, relayState);
    	
        return message;
    }

}
