
// HTTP Inbound Endpoint Transformer
def method = message.getInboundProperty("http.method");
def query;
if ("GET".equals(method)) {
	query = message.getInboundProperty("http.query");
}
else if ("POST".equals(method)) {
	query = message.getPayloadAsString();
}
if (query == null) query = "";

def key = "RelayState=";
if (query.contains(key)) {
	// mule-config.xml から、スクリプトを独立させる際に、 '&#x26'  から '&'　へ置き換えた。
	// mule-config.xml 中でスクリプトを書く制約上、XMLの特殊文字は実体参照で表現されていた。
	def spos = query.indexOf("&" + key) + key.length() + 1;
	def epos = query.indexOf("&", spos);
	
	//　上記の'&'と同様の理由で、'&#x3C' から '<'　へ置き換えた。
	if (epos < 0) epos = query.length();
	if (spos < epos) {
		query = query.substring(spos, epos);
	}
	else {
		query = "";
	}
}
else {
	query = "";
}
message.setSessionProperty("citk.relaystate", query);

return message;
