package jp.co.ogis_ri.citk.authn.saml2.web;


import static org.junit.Assert.*;

import java.util.Date;

import jp.co.ogis_ri.citk.authn.saml2.web.AccessFilter;
import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.NameIDCache;

import mockit.Deencapsulation;

import org.apache.commons.httpclient.Cookie;


import org.junit.Test;
import org.mule.RequestContext;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.http.HttpConnector;

public class AccessFilterTestCase extends AbstractMuleContextTestCase{

	private AccessFilter filter = new AccessFilter();
	private String nameID = "m//y2PWdQQL8MZAmE3ml9wTp0Cjy";
	private String nameID_value= "<saml:NameID Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:transient\" NameQualifier=\"citkidp\" SPNameQualifier=\"citksp\">m//y2PWdQQL8MZAmE3ml9wTp0Cjy</saml:NameID>";

	@Test
	public void testAccept_emptyCache() throws Exception {
		MuleMessage message = new DefaultMuleMessage("OK", muleContext);
		RequestContext.setEvent(getTestEvent(message));
        
        Cookie[] cookies = new Cookie[2];
        Date date = new Date();
		cookies[0] = new Cookie(".citk202.com", CitkConstants.NAMEID_KEY, nameID, "/", date, false);
        cookies[1] = new Cookie(".citk202.com", CitkConstants.IDP_ENTITYID_KEY, "idp202", "/", date, false);
        
        message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies, PropertyScope.INBOUND);

        NameIDCache cache = Deencapsulation.newInstance(NameIDCache.class);
		filter.setCache(cache);
        
		assertFalse(filter.accept(message));
	}
	
	@Test
	public void testAccept_noCookies() throws Exception {
		MuleMessage message = new DefaultMuleMessage("OK", muleContext);
		RequestContext.setEvent(getTestEvent(message));
		
		NameIDCache cache = Deencapsulation.newInstance(NameIDCache.class);
		cache.add(nameID, nameID_value);
		filter.setCache(cache);
		
		assertFalse(filter.accept(message));
	}
	
	@Test
	public void testAccept_noIdpEntityIdCookie() throws Exception {
		MuleMessage message = new DefaultMuleMessage("OK", muleContext);
		RequestContext.setEvent(getTestEvent(message));
		
		Cookie[] cookies = new Cookie[1];
		Date date = new Date();
		cookies[0] = new Cookie(".citk202.com", CitkConstants.NAMEID_KEY, nameID, "/", date, false);
		
		message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies, PropertyScope.INBOUND);
		
		NameIDCache cache = Deencapsulation.newInstance(NameIDCache.class);
		cache.add(nameID, nameID_value);
		filter.setCache(cache);
		
        assertFalse(filter.accept(message));
	}
	
	@Test
	public void testAccept_noNameIDCookie() throws Exception {
		MuleMessage message = new DefaultMuleMessage("OK", muleContext);
		RequestContext.setEvent(getTestEvent(message));
		
		Cookie[] cookies = new Cookie[1];
		Date date = new Date();
		cookies[0] = new Cookie(".citk202.com", CitkConstants.IDP_ENTITYID_KEY, "idp202", "/", date, false);
	  
	    message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies, PropertyScope.INBOUND);
		
		NameIDCache cache = Deencapsulation.newInstance(NameIDCache.class);
		cache.add(nameID, nameID_value);
		filter.setCache(cache);
		
        assertFalse(filter.accept(message));
        
	}
	
	
	@Test
	public void testAccept() throws Exception {
		MuleMessage message = new DefaultMuleMessage("OK", muleContext);
		RequestContext.setEvent(getTestEvent(message));
        
        Cookie[] cookies = new Cookie[2];
        Date date = new Date();
		cookies[0] = new Cookie(".citk202.com", CitkConstants.NAMEID_KEY, nameID, "/", date, false);
        cookies[1] = new Cookie(".citk202.com", CitkConstants.IDP_ENTITYID_KEY, "idp202", "/", date, false);
        
        message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies, PropertyScope.INBOUND);
        
		NameIDCache cache = Deencapsulation.newInstance(NameIDCache.class);
		cache.add(nameID, nameID_value);
		filter.setCache(cache);
				
        assertTrue(filter.accept(message));

        String expectedNameId = nameID.replaceAll("/", "%2F");
        String resultNameId = message.getSessionProperty(CitkConstants.NAMEID_KEY);
        
        assertEquals(expectedNameId,resultNameId);
	}

}
