//TODO:未使用クラス。OpenAM　Client　Libraryのサンプルとして保存。
package jp.co.ogis_ri.citk.authz;

import jp.co.ogis_ri.citk.authz.xacml.XACMLQuery;
import jp.co.ogis_ri.citk.common.DataUtil;
import jp.co.ogis_ri.citk.common.NameIDCache;
import jp.co.ogis_ri.citk.common.log.CitkLogger;

import org.apache.commons.beanutils.BeanUtils;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Callable;
import org.mule.api.transport.PropertyScope;

/**
 * 認可を行うコンポーネント
 * CITKのMuleに組み込んで使うことを前提としているため、
 * Callableインタフェースに依存している。
 * 
 * @author Saito_Shinya@ogis-ri.co.jp
 */
public class AuthzComponent implements Callable {
	
	
	private static final CitkLogger logger = CitkLogger.getLog(AuthzComponent.class);

	/** mule propertyのMapに格納されているHTTP Methodのキー*/
	private static final String HTTP_METHOD_KEY = "http.method";
	
	private static final String HTTP_HOST_KEY = "Host";
	
	private static final String HTTP_REQUEST_PATH_KEY = "http.request.path";
	
	/** 認可の結果をmule propertyに格納するためのキー*/
	private static final String AUTHZ_RESULT_KEY = "authz.result";
	
	/** リソースプロトコル*/
	private String resourceProtocol = null;
	
	/** ポリシーセットを表す文字列*/
	private String resourceServiceName;
	

	/**
     * ログイン済みユーザのNameIDを収めたキャッシュ。
     * @see NameIDCache
     */
    private NameIDCache cache = null;
	
	/** XACMLクライアントクラス */
	private XACMLQuery xacmlQuery = new XACMLQuery();
	
	@Override
	public Object onCall(MuleEventContext eventContext) throws Exception {
		// TODO subjectIdの取得方法について調査・検討が必要
		MuleMessage message = eventContext.getMessage();
		
//		String iplanet = DataUtil.getCookieValue(
//				message.getInboundProperty("cookies"), "iPlanetDirectoryPro");
//		if (iplanet == null || iplanet.isEmpty()) {
//            // TODO エラーハンドリング実装
//			logger.debug("cookie 'iPlanetDirectoryPro' is not set.");
//        }
//		Object val = cache.get(iplanet);
//
//        if (val == null) {
//        	// TODO エラーハンドリング実装
//        	logger.debug("cookie 'iPlanetDirectoryPro'  is not cached.");
//        }
//        
//		String subjectId = DataUtil.getNameId(val);
		
		String subjectId = DataUtil.getCookieValue(
                eventContext.getMessage().getInboundProperty("cookies"), "nameId");
        logger.debug(eventContext.getMessage().getInboundPropertyNames());
        logger.debug(eventContext.getMessage().getSessionProperty("nameId"));
		
		
		String resourceProtocol = this.resourceProtocol;
		
		// TODO actionIdの取得方法について調査・検討が必要
		// 現在は仮置き
		String actionId = message.getProperty(HTTP_METHOD_KEY, PropertyScope.INBOUND);
		
		String resourceID = resourceProtocol + message.getInboundProperty(HTTP_HOST_KEY) + message.getInboundProperty(HTTP_REQUEST_PATH_KEY);
		
		String authzResult = xacmlQuery.getPolicyDecisionByNameID(subjectId, resourceServiceName, resourceID, actionId);
		message.setProperty(AUTHZ_RESULT_KEY, authzResult, PropertyScope.OUTBOUND);	
		logger.debug("authzResult : " + authzResult);
		
		if(logger.isTraceEnabled()){
			logger.trace(BeanUtils.describe(eventContext));
		}

		return eventContext;
	}
	
	/** PDP(ポリシー決定ポイント:Idp)を表す文字列のsetter */
	public void setPdpEntity(String pdpEntity) {
		xacmlQuery.setPdpEntity(pdpEntity);
	}

	/** PEP(ポリシー実行ポイント:mule)を表す文字列のsetter */
	public void setPepEntity(String pepEntity) {
		xacmlQuery.setPepEntity(pepEntity);
	}

	public void setResourceProtocol(String resourceProtocol) {
		this.resourceProtocol = resourceProtocol;
	}
	
	public void setResourceServiceName(String resourceServiceName) {
		this.resourceServiceName = resourceServiceName;
	}
		
    public void setCache(NameIDCache cache) {
        this.cache = cache;
    }

}
