//TODO:未使用クラス。OpenAM　Client　Libraryのサンプルとして保存。
/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authz.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.context.Action;
import com.sun.identity.xacml.context.Attribute;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Decision;
import com.sun.identity.xacml.context.Environment;
import com.sun.identity.xacml.context.Request;
import com.sun.identity.xacml.context.Resource;
import com.sun.identity.xacml.context.Response;
import com.sun.identity.xacml.context.Result;
import com.sun.identity.xacml.context.Subject;

/**
 * XACMLの認可処理を行うためのユーティリティクラス。
 * @author Saito_Shinya@ogis-ri.co.jp
 *
 */
public class XACMLUtils {

	

	
	/**
	 * XACML リクエストオブジェクトを作成する
	 * 
	 * @param subjectId
	 *            サブジェクトID
	 * @param subjectIdType
	 *            サブジェクトIDの型
	 * @param subjectCategory
	 *            サブジェクトのカテゴリ
	 * @param resourceId
	 *            リソースID
	 * @param resourceIdType
	 *            リソースIDの型
	 * @param resourceServiceName
	 *            リソースサービス名
	 * @param serviceNameType
	 *            リソースサービス名の型
	 * @param actionId
	 *            アクションID
	 * @param actionIdType
	 *            アクション IDの型
	 * @return Request XACML リクエストオブジェクト
	 * @throws XACMLException リクエストオブジェクトの作成に失敗した場合
	 * @throws URISyntaxException XACMLの各属性のURI参照が間違っていた場合
	 */
	public static Request createXacmlRequest(String subjectId, String subjectIdType,
			String subjectCategory, String resourceId, String resourceIdType,
			String resourceServiceName, String serviceNameType, String actionId,
			String actionIdType) throws XACMLException, URISyntaxException {

		Request request = ContextFactory.getInstance().createRequest();

		// Subject
		Subject subject = ContextFactory.getInstance().createSubject();
		subject.setSubjectCategory(new URI(subjectCategory));

		Attribute subjectAttribute = ContextFactory.getInstance().createAttribute();
		subjectAttribute.setAttributeId(new URI(XACMLConstants.SUBJECT_ID));
		subjectAttribute.setDataType(new URI(subjectIdType));
		List<String> subjetValueList = new ArrayList<String>();
		subjetValueList.add(subjectId);
		subjectAttribute.setAttributeStringValues(subjetValueList);
		List<Attribute> subjectAttributeList = new ArrayList<Attribute>();
		subjectAttributeList.add(subjectAttribute);
		subject.setAttributes(subjectAttributeList);

		List<Subject> subjectList = new ArrayList<Subject>();
		subjectList.add(subject);
		request.setSubjects(subjectList);

		// Resource
		Resource resource = ContextFactory.getInstance().createResource();

		Attribute resourceAttribute = ContextFactory.getInstance().createAttribute();
		resourceAttribute.setAttributeId(new URI(XACMLConstants.RESOURCE_ID));
		resourceAttribute.setDataType(new URI(resourceIdType));
		List<String> resourceValueList = new ArrayList<String>();
		resourceValueList.add(resourceId);
		resourceAttribute.setAttributeStringValues(resourceValueList);
		List<Attribute> resourceAttributeList = new ArrayList<Attribute>();
		resourceAttributeList.add(resourceAttribute);

		// ServiceName
		Attribute serviceNameAttribute = ContextFactory.getInstance().createAttribute();
		serviceNameAttribute.setAttributeId(new URI(XACMLConstants.TARGET_SERVICE));
		serviceNameAttribute.setDataType(new URI(serviceNameType));
		List<String> servineNameValueList = new ArrayList<String>();
		servineNameValueList.add(resourceServiceName);
		serviceNameAttribute.setAttributeStringValues(servineNameValueList);
		resourceAttributeList.add(serviceNameAttribute);
		resource.setAttributes(resourceAttributeList);

		List<Resource> resourceList = new ArrayList<Resource>();
		resourceList.add(resource);
		request.setResources(resourceList);

		// Action
		Action action = ContextFactory.getInstance().createAction();
		Attribute actionAttribute = ContextFactory.getInstance().createAttribute();
		actionAttribute.setAttributeId(new URI(XACMLConstants.ACTION_ID));
		actionAttribute.setDataType(new URI(actionIdType));

		List<String> actionValueList = new ArrayList<String>();
		actionValueList.add(actionId);
		actionAttribute.setAttributeStringValues(actionValueList);
		List<Attribute> actionAttributeList = new ArrayList<Attribute>();
		actionAttributeList.add(actionAttribute);
		action.setAttributes(actionAttributeList);

		request.setAction(action);

		// Environment
		Environment environment = ContextFactory.getInstance()
				.createEnvironment();
		request.setEnvironment(environment);
		
		return request;
	}

	/**
	 * XACMLResponseオブジェクトから認可結果を取得します。
	 * @param xacmlResponse XACMLレスポンスオブジェクト
	 * @return　String 認可結果 Permit : 許可 Deny : 拒否 Indeterminate : 判断不能
	 */
	public static String getDecisionResult(Response xacmlResponse) {
		@SuppressWarnings("unchecked")
		List<Object> results = xacmlResponse.getResults();
		String decisionResult = null;
		
		if (results.size() > 0) {
			Result policyResult = (Result) results.get(0);
			if (policyResult != null) {
				Decision decision = (Decision) policyResult.getDecision();
				if (decision != null) {
					decisionResult = decision.getValue();
					if (decisionResult != null) {
						return decisionResult;
					}
				}
			}
		}
		return decisionResult;
	}
}
