//TODO:未使用クラス。OpenAM　Client　Libraryのサンプルとして保存。
/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authz.xacml;

import jp.co.ogis_ri.citk.authz.common.AuthzConstants;
import jp.co.ogis_ri.citk.authz.common.XACMLUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.xacml.client.XACMLRequestProcessor;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.context.Request;
import com.sun.identity.xacml.context.Response;

/**
 * 認可処理を実施する。
 * 
 * @author Saito_Shinya@ogis-ri.co.jp
 */
public class XACMLQuery {
	

    /**
     * ロガー。
     */
    private final Log logger = LogFactory.getLog(XACMLQuery.class);

    /**
     * PDP entity名。
     */
    private String pdpEntity;

    /**
     * PEP entity名。
     */
    private String pepEntity;

    /**
     * 「アクセス許可」を表す定数。
     */
    public static final String PERMIT = "Permit";

    /**
     * 「アクセス拒否」を表す定数 。
     */
    public static final String DENY = "Deny";

    /**
     * 「判断不能」を表す定数 。
     */
    public static final String INDETERMINATE = "Indeterminate";

    /**
     * コンストラクタ。
     */
    public XACMLQuery() {

    }

    /**
     * UserID を使用して認可処理を実施する。
     * 
     * @param userId
     *            X500形式のユーザID
     * @param resourceServiceName
     *            リソースサービス名
     * @param resourceId
     *            　リソースID
     * @param actionId
     *            アクションID
     * @return String 認可結果 Permit : 許可 Deny : 拒否 Indeterminate : 判断不能
     * @throws SAML2Exception
     *             認可処理が正常に行われなかった場合
     */
    public String getPolicyDecisionByUserID(String userId,
            String resourceServiceName, String resourceId, String actionId)
            throws SAML2Exception {

        String subjectIdType = XACMLConstants.X500NAME;

        return getPolicyDecision(userId, subjectIdType, resourceServiceName,
                resourceId, actionId);
    }

    /**
     * NameID を使用して認可処理を実施する。
     * 
     * @param nameId
     *            SAML2のnameID
     * @param resourceServiceName
     *            リソースサービス名
     * @param resourceId
     *            　リソースID
     * @param actionId
     *            アクションID
     * @return String 認可結果 Permit : 許可 Deny : 拒否 Indeterminate : 判断不能
     * @throws SAML2Exception
     *             認可処理が正常に行われなかった場合
     */
    public String getPolicyDecisionByNameID(String nameId,
            String resourceServiceName, String resourceId, String actionId)
            throws SAML2Exception {

        String subjectIdType = XACMLConstants.SAML2_NAMEID;

        return getPolicyDecision(nameId, subjectIdType, resourceServiceName,
                resourceId, actionId);
    }

    /**
     * サブジェクトタイプを指定して認可処理を実施する。
     * 
     * @param subjectId
     *            subjectId
     * @param resourceServiceName
     *            リソースサービス名
     * @param resourceId
     *            リソースID
     * @param actionId
     *            アクションID
     * @return String 認可結果 Permit : 許可 Deny : 拒否 Indeterminate : 判断不能
     * @throws SAML2Exception
     *             認可処理が正常に行われなかった場合
     */
    public String getPolicyDecision(String subjectId, String subjectIdType,
            String resourceServiceName, String resourceId, String actionId)
            throws SAML2Exception {

        String subjectCategory = AuthzConstants.SUBJECT_CATEGORY;
        String resourceIdType = AuthzConstants.RESOURCE_ID_TYPE;
        String serviceNameType = AuthzConstants.SERVICE_NAME_TYPE;
        String actionIdType = AuthzConstants.ACTION_TYPE;

        return getPolicyDecision(pdpEntity, pepEntity, subjectId,
                subjectIdType, subjectCategory, resourceId, resourceIdType,
                resourceServiceName, serviceNameType, actionId, actionIdType);

    }

    /**
     * 認可処理を実施する。
     * 
     * @param pdpEntityId
     *            PDPエンティティID
     * @param pepEntityId
     *            PEPエンティティID
     * @param subjectId
     *            サブジェクトID
     * @param subjectIdType
     *            サブジェクトIDの型
     * @param subjectCategory
     *            サブジェクトのカテゴリ
     * @param resourceId
     *            リソースID
     * @param resourceIdType
     *            リソースIDの型
     * @param resourceServiceName
     *            リソースサービス名
     * @param serviceNameType
     *            リソースサービス名の型
     * @param actionId
     *            アクションID
     * @param actionIdType
     *            アクション IDの型
     * @return String 認可結果 Permit : 許可 Deny : 拒否 Indeterminate : 判断不能
     * @throws SAML2Exception
     *             認可処理が正常に行われなかった場合
     */
    public String getPolicyDecision(String pdpEntityId, String pepEntityId,
            String subjectId, String subjectIdType, String subjectCategory,
            String resourceId, String resourceIdType,
            String resourceServiceName, String serviceNameType,
            String actionId, String actionIdType) throws SAML2Exception {

        try {
        	        		
            Request xacmlRequest = XACMLUtils.createXacmlRequest(subjectId,
                    subjectIdType, subjectCategory, resourceId, resourceIdType,
                    resourceServiceName, serviceNameType, actionId,
                    actionIdType);
            
            if (logger.isDebugEnabled()) {
                logger.debug("ProcessRequest():xacmlRequest:"
                        + xacmlRequest.toXMLString(true, true));
            }
            
            Response xacmlResponse = XACMLRequestProcessor.getInstance()
                    .processRequest(xacmlRequest, pdpEntityId, pepEntityId);

            String decisionResult = XACMLUtils.getDecisionResult(xacmlResponse);
            if (logger.isDebugEnabled()) {
                logger.debug("ProcessRequest():xacmlResponse:"
                        + xacmlResponse.toXMLString(true, true));
            }

            return decisionResult;
        } catch (Exception ex) {
            logger.error("XACMLQuery failed to send the XACMLRequest", ex);
            throw new SAML2Exception(ex);
        }
    }

    public void setPdpEntity(String pdpEntity) {
        this.pdpEntity = pdpEntity;
    }

    public void setPepEntity(String pepEntity) {
        this.pepEntity = pepEntity;
    }
    
}
