/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authz.common;

import static org.junit.Assert.assertTrue;

import java.net.URI;
import java.util.List;

import jp.co.ogis_ri.citk.authz.common.XACMLUtils;

import org.junit.Test;
import org.w3c.dom.Element;

import com.sun.identity.xacml.context.Action;
import com.sun.identity.xacml.context.Environment;
import com.sun.identity.xacml.context.Request;
import com.sun.identity.xacml.context.Resource;
import com.sun.identity.xacml.context.Response;
import com.sun.identity.xacml.context.Subject;
import com.sun.identity.xacml.context.impl.ResponseImpl;

/**
 * XACMLUtilsのテストクラス。
 * @author Saito_Shinya@ogis-ri.co.jp
 */
public class XACMLUtilsTest {

    /** SubjectのID. */
    private static final String SUBJECT_ID = "user1";

    /** Subjectの型 */
    private static final String SUBJECT_ID_TYPE = "urn:oasis:names:tc:xacml:1.0:data-type:x500Name";

    /** SUBJECTのカテゴリ */
    private static final String SUBJECT_CATEGORY = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";

    /** Resourceの ID */
    private static final String RESOURCE_ID = "http://localhost:8080/";

    /** Resourceの型 */
    private static final String RESOURCE_ID_TYPE = "http://www.w3.org/2001/XMLSchema#string";

    /** Serviceの名前 */
    private static final String SERVICE_NAME = "iPlanetAMWebAgentService";

    private static final String SERVICE_NAME_TYPE = "http://www.w3.org/2001/XMLSchema#string";

    private static final String ACTION_ID = "GET";
    
    private static final String ACTION_TYPE = "http://www.w3.org/2001/XMLSchema#string";

    private static final String RESPONSE_XML = "<xacml-context:Response xmlns:xacml-context=\"urn:oasis:names:tc:xacml:2.0:context:schema:os\" >" +
    		"<xacml-context:Result ResourceId=\"http://localhost:8080/\">" +
    		"<xacml-context:Decision>Permit</xacml-context:Decision>" +
    		"<xacml-context:Status>" +
    		"<xacml-context:StatusCode Value=\"urn:oasis:names:tc:xacml:1.0:status:ok\"></xacml-context:StatusCode>" +
    		"<xacml-context:StatusMessage>ok</xacml-context:StatusMessage>" +
    		"<xacml-context:StatusDetail xmlns:xacml-context=\"urn:oasis:names:tc:xacml:2.0:context:schema:cd:04\"><xacml-context:StatusDetail/></xacml-context:StatusDetail>" +
    		"</xacml-context:Status>" +
    		"</xacml-context:Result>" +
    		"</xacml-context:Response>";
    
    
    @Test
    public void testCreateXacmlRequest() throws Exception {

        Request request = XACMLUtils.createXacmlRequest(SUBJECT_ID,
                SUBJECT_ID_TYPE,
                SUBJECT_CATEGORY,
                RESOURCE_ID,
                RESOURCE_ID_TYPE,
                RESOURCE_ID,
                RESOURCE_ID_TYPE, ACTION_ID,
                ACTION_TYPE);

        //Subject
        List<Subject> subjects = request.getSubjects();
        Subject subject = subjects.get(0);
        String subjectXML = subject.toXMLString();
        URI subjectCategory = subject.getSubjectCategory();
        assertTrue(subjectXML.contains(SUBJECT_ID));
        assertTrue(subjectXML.contains(SUBJECT_ID_TYPE));
        assertTrue(subjectXML.contains(SUBJECT_CATEGORY));

        //Resource
        List<Resource> resources = request.getResources();
        Resource resource = resources.get(0);
        String resourceXML = resource.toXMLString();
        assertTrue(resourceXML.contains(RESOURCE_ID));
        assertTrue(resourceXML.contains(RESOURCE_ID_TYPE));
       // assertTrue(resourceXML.contains(SERVICE_NAME));
       // assertTrue(resourceXML.contains(SERVICE_NAME_TYPE));
        
        //Action
        Action action = request.getAction();
        String actionXML = action.toXMLString();
        assertTrue(actionXML.contains(ACTION_ID));
        assertTrue(actionXML.contains(ACTION_TYPE));
        
        //Environment
        Environment environment = request.getEnvironment();
        assertTrue(environment != null);
    }
    
    @Test
    public void testGetDecisionResult() throws Exception {
        Response xacmlResponse = new ResponseImpl(RESPONSE_XML);
        assertTrue(xacmlResponse.toXMLString().contains("Permit"));
    }
    

}
