/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common;

/**
 * CITKの共通Constantsクラス実装。
 * @author ISP Shiraishi
 *
 */
public class CitkConstants {
	public static final String NAMEID_KEY = "nameId";
	public static final String AUTHZ_REQUEST_PARAM = "authz";
	public static final String IDP_ENTITYID_KEY = "idpEntityId";
	public static final String CITK_RELAYSTATE_KEY = "citk.relaystate";
	public static final String CITK_ACS_STATUS_KEY = "citk.acs.status";
	public static final String CITK_ACS_STATUS_OK = "ok";
	public static final String CITK_ACS_STATUS_NG = "ng";
	public static final String RELAYSTATE_PARAM = "RelayState";
	
	public static final String AUTHZ_RESULT_KEY = "authz.result";
	public static final String AUTHZ_PERMIT = "Permit";
	public static final String AUTHZ_DENY = "Deny";
	public static final String AUTHZ_INDETERMINATE = "Indeterminate";
	
	public static final String OUTBOUND_ADDRESS = "outBound.address";
	public static final String OUTBOUND_PROTOCOL = "outBound.protocol";
	
	
	public static final String LOG_MESSAGE_PROPERTIES = "citk-log-messages";
	
	public static final String ERROR_MESSAGE_PROPERTIES = "citk-exception-messages";
	public static final String ERROR_HTTPSTATUS_PROPERTIES = "citk-exception-httpStatuses";
	
	public static final String LOG_MSG_NAMEID_COOKIE						= "1";
	public static final String LOG_MSG_NOT_CONTAIN_NAMEID_COOKIE			= "2";
	public static final String LOG_MSG_IDPENTITYID_COOKIE					= "3";
	public static final String LOG_MSG_NOT_CONTAIN_IDPENTITYID_COOKIE		= "4";
	public static final String LOG_MSG_REQUEST_NOT_AUTHORIZATION			= "5";
	public static final String LOG_MSG_RELAYSTATE_IS						= "6";
	public static final String LOG_MSG_CREATE_RELAYSTATE					= "7";
	public static final String LOG_MSG_AUTHN_FEDLET_RESPONSE				= "8";
	public static final String LOG_MSG_GET_NAMEID							= "9";
	public static final String LOG_MSG_GET_IDPENTITYID						= "10";
	public static final String LOG_MSG_LOGICAL_ADDRESS						= "11";
	public static final String LOG_MSG_NADEID_IS							= "12";
	public static final String LOG_MSG_AUTHZ_DECISION						= "13";
	public static final String LOG_MSG_PHYSICAL_ADDRESS						= "14";
	public static final String LOG_MSG_CITK_EXCEPTION_MESSAGE				= "15";
	
    
	public static final String ERROR_MSG_NAMEID_IS_NULL 					= "1";
	public static final String ERROR_MSG_IDPENTITYID_IS_NULL				= "2";
	public static final String ERROR_MSG_INVALID_ACSSTATUS 					= "3";
	public static final String ERROR_MSG_LOCATION_IS_NULL 					= "4";
	public static final String ERROR_MSG_NOT_GET_REQUEST_CACHE 				= "5";
	public static final String ERROR_MSG_NOT_CONTAIN_PAYLOARD 				= "6";
	public static final String ERROR_MSG_NOT_CONTAIN_NAEID_TAG 				= "7";
	public static final String ERROR_MSG_NOT_CONTAIN_NAEID 					= "8";
	public static final String ERROR_MSG_NOT_CONTAIN_IDPENTITYID 			= "9";
	public static final String ERROR_MSG_AUTHORIZE_FAILUER 					= "10";
	public static final String ERROR_MSG_NOT_CONTAIN_POLICYDECISION_TAG 	= "11";
	public static final String ERROR_MSG_NOT_CONTAIN_POLICYDECISION 		= "12";
	public static final String ERROR_MSG_NAMEID_ENCODE_FAILUER 				= "13";
	public static final String ERROR_MSG_GET_QUERY_FAILUER 					= "14";
	public static final String ERROR_MSG_RELAYSTATE_IS_NULL 				= "15";
	public static final String ERROR_MSG_NOT_CONTAIN_TARGETKEY 				= "16";
	public static final String ERROR_MSG_GET_OUTBOUND_ENDPOINT_FAILUER 		= "17";
	public static final String ERROR_MSG_GET_REQUEST_FAILUER 				= "18";

}
