/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.log;

import java.util.ResourceBundle;

import jp.co.ogis_ri.citk.common.CitkConstants;



/**
 * CITKのログメッセージ管理クラス実装。
 * @author ISP Shiraishi
 *
 */
public class CitkLogMapping {
	
	/**
     * このクラスのシングルトンオブジェクト。
     */
    private static CitkLogMapping me = new CitkLogMapping();
    
        
	/**
     * LogMessagePropertiesオブジェクト。
     */
    private ResourceBundle message_rb = null;
	
	/**
	 * コンストラクタ
	 */
	private CitkLogMapping() {
		
		//メッセージの読み込み
		message_rb = ResourceBundle.getBundle(CitkConstants.LOG_MESSAGE_PROPERTIES);

	}

	/**
     * ログメッセージを取得する。
     * 
     * @param key ログメッセージコード
     * @return ログメッセージ
     */
	public String getLogMessage(String key){
		return message_rb.getString(key);
	}
	
    /**
     * このオブジェクトのシングルトンインスタンスを取得する。
     * @return CitkErrorMappingオブジェクト
     */
    public static CitkLogMapping getInstance() {
        return me;
    }
	
}
