/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * CITKLoggerクラス実装。
 * 
 * 1.trace (the least serious)
 * 2.debug
 * 3.info
 * 4.warn
 * 5.error
 * 6.fatal (the most serious)
 * 
 * @author ISP Shiraishi
 *
 */
public class CitkLogger {

	/**
     * ラップ対象のLogger。
     */
	private Log log = null;
	
	private static CitkLogMapping logMapping = null;


	public static CitkLogger getLog(Class clazz) {
		return new CitkLogger(clazz);
	}
	
	public static CitkLogger getLog(String clazz) {
		return new CitkLogger(clazz);
	}
	
	/**
	 * コンストラクタ（Class）
	 * @param clazz 対象クラス
	 */
	private CitkLogger(Class clazz) {
		log = LogFactory.getLog(clazz);
		logMapping = CitkLogMapping.getInstance();
	}
	
	/**
	 * コンストラクタ（String）
	 * @param clazz 対象クラス
	 */
	private CitkLogger(String clazz) {
		log = LogFactory.getLog(clazz);
		logMapping = CitkLogMapping.getInstance();
	}
	
	/**
	 * ログメッセージ取得。CitkLogMapping（citk-log-messages.properties）に該当の
	 * メッセージコードがない場合はkeyをそのまま返却する。
	 * @param key ログメッセージコード
	 * @param args メッセージパラメータ
	 * @return ログメッセージ
	 */
	private Object getMessage(Object key, String param){
		String res = logMapping.getLogMessage((String)key);
		if(res == null || "".equals(res)){
			return key;
		}
		else{
			if(param == null || "".equals(param)){
				return res;
			}
			else{
				return res + param;
			}
		}
	}
	
	
	/**
	 * fatalレベルログ
	 * @param message 対象メッセージ
	 */
	public void fatal(Object message){
		if(log.isFatalEnabled()){
			log.fatal(getMessage(message, null));
		}
	}
	
	/**
	 * fatalレベルログ
	 * @param message 対象メッセージ
	 */
	public void fatal(Object message, String param){
		if(log.isFatalEnabled()){
			log.fatal(getMessage(message, param));
		}
	}
	
	/**
	 * fatalレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void fatal(Object message, Throwable t){
		if(log.isFatalEnabled()){
			log.fatal(getMessage(message, null), t);
		}
	}
	
	/**
	 * fatalレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void fatal(Object message, String param, Throwable t){
		if(log.isFatalEnabled()){
			log.fatal(getMessage(message, param), t);
		}
	}
	
	/**
	 * errorレベルログ
	 * @param message 対象メッセージ
	 */
	public void error(Object message){
		if(log.isErrorEnabled()){
			log.error(getMessage(message, null));
		}
	}
	
	/**
	 * errorレベルログ
	 * @param message 対象メッセージ
	 */
	public void error(Object message, String param){
		if(log.isErrorEnabled()){
			log.error(getMessage(message, param));
		}
	}
	
	/**
	 * errorレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void error(Object message, Throwable t){
		if(log.isErrorEnabled()){
			log.error(getMessage(message, null), t);
		}
	}
	
	/**
	 * errorレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void error(Object message, String param, Throwable t){
		if(log.isErrorEnabled()){
			log.error(getMessage(message, param), t);
		}
	}
	
	/**
	 * warnレベルログ
	 * @param message 対象メッセージ
	 */
	public void warn(Object message){
		if(log.isWarnEnabled()){
			log.warn(getMessage(message, null));
		}
	}
	
	/**
	 * warnレベルログ
	 * @param message 対象メッセージ
	 */
	public void warn(Object message, String param){
		if(log.isWarnEnabled()){
			log.warn(getMessage(message, param));
		}
	}
	
	/**
	 * warnレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void warn(Object message, Throwable t){
		if(log.isWarnEnabled()){
			log.warn(getMessage(message, null), t);
		}
	}
	
	/**
	 * warnレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void warn(Object message, String param, Throwable t){
		if(log.isWarnEnabled()){
			log.warn(getMessage(message, param), t);
		}
	}
	
	/**
	 * infoレベルログ
	 * @param message 対象メッセージ
	 */
	public void info(Object message){
		if(log.isInfoEnabled()){
			log.info(getMessage(message, null));
		}
	}
	
	/**
	 * infoレベルログ
	 * @param message 対象メッセージ
	 */
	public void info(Object message, String param){
		if(log.isInfoEnabled()){
			log.info(getMessage(message, param));
		}
	}
		
	/**
	 * infoレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void info(Object message, Throwable t){
		if(log.isInfoEnabled()){
			log.info(getMessage(message, null), t);
		}
	}
	
	/**
	 * infoレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void info(Object message, String param, Throwable t){
		if(log.isInfoEnabled()){
			log.info(getMessage(message, param), t);
		}
	}
	
	
	/**
	 * debugレベルログ
	 * @param message 対象メッセージ
	 */
	public void debug(Object message){
		if(log.isDebugEnabled()){
			log.debug(getMessage(message, null));
		}
	}
	
	/**
	 * debugレベルログ
	 * @param message 対象メッセージ
	 */
	public void debug(Object message, String param){
		if(log.isDebugEnabled()){
			log.debug(getMessage(message, param));
		}
	}
	
	/**
	 * debugレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void debug(Object message, Throwable t){
		if(log.isDebugEnabled()){
			log.debug(getMessage(message, null), t);
		}
	}
	
	/**
	 * debugレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void debug(Object message, String param, Throwable t){
		if(log.isDebugEnabled()){
			log.debug(getMessage(message, param), t);
		}
	}
	
	/**
	 * traceレベルログ
	 * @param message 対象メッセージ
	 */
	public void trace(Object message){
		if(log.isTraceEnabled()){
			log.trace(getMessage(message, null));
		}
	}
	
	/**
	 * traceレベルログ
	 * @param message 対象メッセージ
	 */
	public void trace(Object message, String param){
		if(log.isTraceEnabled()){
			log.trace(getMessage(message, param));
		}
	}
	
	/**
	 * traceレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void trace(Object message, Throwable t){
		if(log.isTraceEnabled()){
			log.trace(getMessage(message, null), t);
		}
	}
	
	/**
	 * traceレベルログ
	 * @param message 対象メッセージ
	 * @param t 対象Throwable
	 */
	public void trace(Object message, String param, Throwable t){
		if(log.isTraceEnabled()){
			log.trace(getMessage(message, param), t);
		}
	}

	
	/**
	 * Fatalレベル設定状態確認
	 * @return 設定
	 */
	public boolean isFatalEnabled(){
		return log.isFatalEnabled();
	}
		
	/**
	 * Errorレベル設定状態確認
	 * @return 設定
	 */
	public boolean isErrorEnabled(){
		return log.isErrorEnabled();
	}
		
	/**
	 * Warnレベル設定状態確認
	 * @return 設定
	 */
	public boolean isWarnEnabled(){
		return log.isWarnEnabled();
	}
	
	/**
	 * Infoレベル設定状態確認
	 * @return 設定
	 */
	public boolean isInfoEnabled(){
		return log.isInfoEnabled();
	}
	
	/**
	 * Debugレベル設定状態確認
	 * @return 設定
	 */
	public boolean isDebugEnabled(){
		return log.isDebugEnabled();
	}
	
	/**
	 * Traceレベル設定状態確認
	 * @return 設定
	 */
	public boolean isTraceEnabled(){
		return log.isTraceEnabled();
	}
	
}
