/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.log.exception;

import java.util.ResourceBundle;

import jp.co.ogis_ri.citk.common.CitkConstants;



/**
 * CITKのErrorメッセージ・HttpStatus管理クラス実装。
 * @author ISP Shiraishi
 *
 */
public class CitkErrorMapping {
	
	/**
     * このクラスのシングルトンオブジェクト。
     */
    private static CitkErrorMapping me = new CitkErrorMapping();
    
        
	/**
     * ErrorMessagePropertiesオブジェクト。
     */
    private ResourceBundle message_rb = null;
    
    /**
     * HttpStatusPropertiesオブジェクト。
     */
    private ResourceBundle status_rb = null;
	
    
	/**
	 * コンストラクタ
	 */
	private CitkErrorMapping() {
		
		//メッセージの読み込み
		message_rb = ResourceBundle.getBundle(CitkConstants.ERROR_MESSAGE_PROPERTIES);
		
		//HTTPステータスの読み込み
		status_rb = ResourceBundle.getBundle(CitkConstants.ERROR_HTTPSTATUS_PROPERTIES);
	}
	
    /**
     * エラーメッセージを取得する。
     * 
     * @param key エラーコード
     * @return エラーメッセージ
     */
	public String getErrorMessage(String key){
		return message_rb.getString(key);
	}

    /**
     * HttpStatusを取得する。
     * 
     * @param key エラーコード
     * @return HttpStatus
     */
	public String getErrorStatus(String key){
		return status_rb.getString(key);
	}
	
    /**
     * このオブジェクトのシングルトンインスタンスを取得する。
     * @return CitkErrorMappingオブジェクト
     */
    public static CitkErrorMapping getInstance() {
        return me;
    }
	
}
