/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.log.exception.strategy;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.log.exception.CitkErrorMapping;
import jp.co.ogis_ri.citk.common.log.exception.CitkSystemException;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleProperties;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;


/**
 * Mule ESBのカスタムExceptionStrategyクラス実装。
 * 
 * @author ISP Shiraishi
 *
 */
public class CitkExceptionStrategy extends AbstractMessagingExceptionStrategy {

	public CitkExceptionStrategy(MuleContext muleContext) {
		super(muleContext);
		// TODO Auto-generated constructor stub
	}
	
    /**
     * ログメッセージ出力用オブジェクト。
     */
	private static final CitkLogger logger = CitkLogger.getLog(CitkExceptionStrategy.class);

	private CitkErrorMapping errorMapping = null;
	
    /**
	 * @return errorMapping
	 */
	public CitkErrorMapping getErrorMapping() {
		return errorMapping;
	}

	/**
	 * @param errorMapping セットする errorMapping
	 */
	public void setErrorMapping(CitkErrorMapping errorMapping) {
		this.errorMapping = errorMapping;
	}

	@Override
    /**
     * Exceptionハンドラ
     *
     *　@param　e 対象のException
     * @param event Muleイベント
     * @return MuleEvent
     */
    public MuleEvent handleException(Exception e, MuleEvent event)
    {
    	
		MuleEvent resultEvent = event;
		
		Throwable throwable = e.getCause();

        if(throwable instanceof jp.co.ogis_ri.citk.common.log.exception.CitkSystemException){
    		        	
       		resultEvent.getMessage().setExceptionPayload(null);
       		
       		String key = throwable.getMessage();
       		String message = errorMapping.getErrorMessage(key);
       		String status = errorMapping.getErrorStatus(key);
	
    		resultEvent.getMessage().setPayload(message);
    		resultEvent.getMessage().setOutboundProperty(HttpConstants.HEADER_CONTENT_LENGTH, 
    																			message.length());
    		resultEvent.getMessage().setOutboundProperty(HttpConnector.HTTP_STATUS_PROPERTY,
    																	Integer.parseInt(status));
    		
    		resultEvent.getMessage().setOutboundProperty(MuleProperties.MULE_ENCODING_PROPERTY,"Shift_jis");
    		
    		CitkSystemException messageThrowable = new CitkSystemException(message);
    		logger.error(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, messageThrowable);
        }
        else{
        	return super.handleException(e, event);
        }
        
        return resultEvent;
    }
	
	@Override
    /**
     * Exceptionハンドラ
     *
     *　@param　e 対象のException
     * @param event Muleイベント
     * @param rollbackMethod 
     * @return MuleEvent
     */
	public MuleEvent handleException(Exception ex, MuleEvent event, RollbackSourceCallback rollbackMethod)
	{
		//TODO CITKでOverrideは必要？
		return super.handleException(ex, event, rollbackMethod);
	}
}
