/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.transformer.http;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;


/**
 * Mule ESBのカスタムトランスフォーマークラス実装。
 *
 */
public class PostPropertiesTransformer extends AbstractMessageTransformer {

	public static final String CONTENT_TYPE_WWW_FORM = "www-form";
	
	/**
	 * http://www.w3.org/TR/1999/REC-html401-19991224/
	 */
	public static final String CONTENT_TYPE_X_WWW_FORM_URL_ENCODED ="application/x-www-form-urlencoded";
	
	/**
	 * http://www.ietf.org/rfc/rfc2388.txt
	 */
	public static final String CONTENT_TYPE_MULTI_PART_FORM_DATA = "multipart/form-data";
	
	@Override
	 /**
     * FedletのAssertionConsumerServiceに対し認証結果を渡すための前処理。
     * @param message 変換対象のMuleMessageオブジェクト
     * @param outputEncoding エンコード
     * @return 変換後のMuleMessageオブジェクト
     * @throws TransformerException
     */
	public Object transformMessage(MuleMessage message, String outputEncoding)
			throws TransformerException 
	{
		// POSTでFormをSubmitするとき Payload の内容をクエリー値として利用するため、
		// Inbound Property から Outbound Property へ
		// 必要な値をコピーする。
		String inMethod = message.getInboundProperty(HttpConnector.HTTP_METHOD_PROPERTY);
		String cType = message.getInboundProperty(HttpConstants.HEADER_CONTENT_TYPE, "");
		
		if (HttpConstants.METHOD_POST.equalsIgnoreCase(inMethod))
		{
			message.setOutboundProperty(HttpConnector.HTTP_METHOD_PROPERTY, inMethod);
//			if (cType.contains(CONTENT_TYPE_WWW_FORM))
			if (cType.equalsIgnoreCase(CONTENT_TYPE_X_WWW_FORM_URL_ENCODED) ) 
			{
				message.setOutboundProperty(HttpConstants.HEADER_CONTENT_TYPE, cType);
				message.setOutboundProperty(HttpConstants.HEADER_CONTENT_LENGTH, 
				message.getInboundProperty(HttpConstants.HEADER_CONTENT_LENGTH));
			}
		}
		
		// cookies should be keep on MuleMessage Because cookies are used following flows.
		// inbound scope properties is deleted when message is dispatched.
		Object cookies = message.getInboundProperty(HttpConnector.HTTP_COOKIES_PROPERTY);
		if (cookies != null) 
		{
			message.setSessionProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies);
		}
		return message;
	}

}
