package jp.co.ogis_ri.citk.common;

import static org.junit.Assert.*;

import java.util.HashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.common.NameIDCache;

import mockit.Deencapsulation;

import org.junit.Test;

public class NameIDCacheTestCase {
	
	private static Map<String, String> cache;
	private static String key = "testKey";
	private static String value = "testValue";
	
	private static String addKey = "testKey2";
	private static String addValue = "testValue2";
	
	static {
		cache = new HashMap<String, String>();
		cache.put(key, value);
	}


	@Test
	public void testAddAndGet() {
		NameIDCache target = Deencapsulation.newInstance(NameIDCache.class);
		target.setCache(cache);
		
		target.add(addKey, addValue);
		
		String result = target.get(addKey);
		
		assertNotNull(result);
		assertEquals(addValue, result);
	}

	@Test
	public void testRemove() {
		NameIDCache target = Deencapsulation.newInstance(NameIDCache.class);
		target.setCache(cache);
		
		target.remove(key);
		
		String result = target.get(key);
		
		assertNull(result);
	}

	@Test
	public void testUpdate() {
		NameIDCache target = Deencapsulation.newInstance(NameIDCache.class);
		target.setCache(cache);
		
		target.update(key, addValue);
		
		String result = target.get(key);
		
		assertNotNull(result);
		assertEquals(addValue, result);
	}

	@Test
	public void testGetInstance() {
		NameIDCache target = Deencapsulation.newInstance(NameIDCache.class);
		assertEquals(NameIDCache.class, target.getClass());
	}

}
