/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package jp.co.ogis_ri.citk.common;

import static org.junit.Assert.*;

import java.util.concurrent.ConcurrentHashMap;

import jp.co.ogis_ri.citk.common.RequestParameterCache;

import mockit.Deencapsulation;

import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class RequestParameterCacheTest extends AbstractMuleContextTestCase{

	
	@Test
	public final void testAddAndGet() {
		RequestParameterCache cache = Deencapsulation.newInstance(RequestParameterCache.class);
		cache.setCache(new ConcurrentHashMap<String, MuleMessage>());
	
		MuleMessage message1 = new DefaultMuleMessage("test1",muleContext);

		cache.add(null, null);
        assertEquals(0, cache.getCache().size());
        
        cache.add("test1", message1);
        assertEquals(1, cache.getCache().size());
        
        MuleMessage result = cache.get("test1");
        
        assertEquals(message1, result);
       	}

	@Test
	public final void testRemove() {

		RequestParameterCache cache = Deencapsulation.newInstance(RequestParameterCache.class);
		cache.setCache(new ConcurrentHashMap<String, MuleMessage>());
	
		MuleMessage message1 = new DefaultMuleMessage("test1",muleContext);
		
		cache.add("test1", message1);
		cache.remove("test1");
        assertEquals(0, cache.getCache().size());
		
	}

	@Test
	public final void testUpdate() {
		RequestParameterCache cache = Deencapsulation.newInstance(RequestParameterCache.class);
		cache.setCache(new ConcurrentHashMap<String, MuleMessage>());
	
		MuleMessage message1 = new DefaultMuleMessage("test1",muleContext);
		MuleMessage message2 = new DefaultMuleMessage("test2",muleContext);
				
		cache.add("test1", message1);
		assertEquals(cache.get("test1"), message1);
		
		cache.update("test1", message2);
		assertEquals(cache.get("test1"), message2);
		
	}

	@Test
	public final void testGetInstance() {
		RequestParameterCache cache1 = RequestParameterCache.getInstance();
		RequestParameterCache cache2 = RequestParameterCache.getInstance();
		assertSame(cache1, cache2);
        assertSame(cache1.getCache(), cache2.getCache());
	}



}
