package jp.co.ogis_ri.citk.common.log;

import static org.junit.Assert.*;
import jp.co.ogis_ri.citk.common.CitkConstants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

public class CitkLoggerTestCase {

	@Test
	public void testGetLogClass() {
		CitkLogger target = CitkLogger.getLog(CitkLoggerTestCase.class);
		assertEquals(CitkLogger.class, target.getClass());
	}

	@Test
	public void testGetLogString() {
		CitkLogger target = CitkLogger.getLog("jp.co.ogis_ri.citk.common.log.CitkLoggerTestCase");
		assertEquals(CitkLogger.class, target.getClass());
	}

	@Test
	public void testlog() {
		CitkLogger target = CitkLogger.getLog(CitkLoggerTestCase.class);
		
		if(target.isDebugEnabled() || target.isErrorEnabled() || 
				target.isFatalEnabled() || target.isInfoEnabled() || 
				target.isTraceEnabled() || target.isWarnEnabled()){
		}
		else{
			fail();
		}
		
		String testParam = "testParam";
		Exception e = new NullPointerException();
				
		target.debug(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE);
		target.debug(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam);
		target.debug(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, e);
		target.debug(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam, e);
		
		target.trace(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE);
		target.trace(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam);
		target.trace(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, e);
		target.trace(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam, e);
		
		target.warn(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE);
		target.warn(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam);
		target.warn(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, e);
		target.warn(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam, e);
		
		target.info(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE);
		target.info(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam);
		target.info(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, e);
		target.info(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam, e);
		
		target.error(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE);
		target.error(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam);
		target.error(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, e);
		target.error(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam, e);
		
		target.fatal(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE);
		target.fatal(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam);
		target.fatal(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, e);
		target.fatal(CitkConstants.LOG_MSG_CITK_EXCEPTION_MESSAGE, testParam, e);
	}


}
