package jp.co.ogis_ri.citk.common.log.exception;

import static org.junit.Assert.*;
import jp.co.ogis_ri.citk.common.log.exception.CitkErrorMapping;

import org.junit.Test;

public class CitkErrorMappingTestCase {

	private static String key = "1";
	private static String messageValue = "NameIDがメッセージに含まれていません";
	private static String statusValue = "500";
	
	@Test
	public void testGetErrorMessage() {
		CitkErrorMapping target = CitkErrorMapping.getInstance();
		
		String result = target.getErrorMessage(key);
		assertNotNull(result);
		assertEquals(messageValue, result);
	}

	@Test
	public void testGetErrorStatus() {
		CitkErrorMapping target = CitkErrorMapping.getInstance();
		
		String result = target.getErrorStatus(key);
		assertNotNull(result);
		assertEquals(statusValue, result);		
	}

	@Test
	public void testGetInstance() {
		CitkErrorMapping target1 = CitkErrorMapping.getInstance();
		CitkErrorMapping target2 = CitkErrorMapping.getInstance();

		assertSame(target1, target2);
		assertEquals(target1.getErrorMessage(key), target2.getErrorMessage(key));
		assertEquals(target1.getErrorStatus(key), target2.getErrorStatus(key));
	}

}
