package jp.co.ogis_ri.citk.common.log.exception;

import static org.junit.Assert.*;
import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.log.exception.CitkSystemException;

import org.junit.Test;

public class CitkSystemExceptionTestCase {

	
	@Test(expected = CitkSystemException.class)
	public void testCitkSystemException() {
		throw new CitkSystemException();
	}

	@Test(expected = CitkSystemException.class)
	public void testCitkSystemExceptionStringThrowable() {
		try{
			throw new CitkSystemException(new NullPointerException());
		}
		catch(CitkSystemException e){
			//success
			assertEquals(NullPointerException.class, e.getCause().getClass());
			throw e;
		}
	}

	@Test(expected = CitkSystemException.class)
	public void testCitkSystemExceptionString() {
		try{
			throw new CitkSystemException(CitkConstants.ERROR_MSG_AUTHORIZE_FAILUER);
		}
		catch(CitkSystemException e){
			//success
			assertEquals(CitkConstants.ERROR_MSG_AUTHORIZE_FAILUER,e.getMessage());
			throw e;
		}
	}

	@Test(expected = CitkSystemException.class)
	public void testCitkSystemExceptionThrowable() {
		try{
			throw new CitkSystemException(CitkConstants.ERROR_MSG_AUTHORIZE_FAILUER,
														new NullPointerException());
		}
		catch(CitkSystemException e){
			//success
			assertEquals(CitkConstants.ERROR_MSG_AUTHORIZE_FAILUER,e.getMessage());
			assertEquals(NullPointerException.class, e.getCause().getClass());
			throw e;
		}
	}

}
