package jp.co.ogis_ri.citk.common.log.exception.strategy;

import static org.junit.Assert.*;
import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.log.exception.CitkErrorMapping;
import jp.co.ogis_ri.citk.common.log.exception.CitkSystemException;
import jp.co.ogis_ri.citk.common.log.exception.strategy.CitkExceptionStrategy;

import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.config.MuleProperties;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;

public class CitkExceptionStrategyTestCase extends AbstractMuleContextTestCase{
		
	@Test
	public void testHandleExceptionExceptionMuleEvent() {
		CitkExceptionStrategy target = new CitkExceptionStrategy(muleContext);
		CitkErrorMapping errorMapping = CitkErrorMapping.getInstance();
		target.setErrorMapping(errorMapping);
		
		MuleMessage okMessage = new DefaultMuleMessage("OK", muleContext);
		MuleSession session = MuleTestUtils.getTestSession(muleContext);

        MuleEvent event = new DefaultMuleEvent(okMessage, MessageExchangePattern.REQUEST_RESPONSE, session);
        
        CitkSystemException citkSystemException = new CitkSystemException(CitkConstants.ERROR_MSG_NAMEID_IS_NULL);
        TransformerMessagingException transformerMessagingException = new TransformerMessagingException(null, event, null, citkSystemException);

        MuleEvent result = null;

       	result = target.handleException(transformerMessagingException, event);

        MuleMessage resultMessage = result.getMessage();
        
        assertNull(resultMessage.getExceptionPayload());
        assertEquals(resultMessage.getPayload(),"NameIDがメッセージに含まれていません");
        assertEquals(resultMessage.getOutboundProperty(HttpConstants.HEADER_CONTENT_LENGTH),
        						"NameIDがメッセージに含まれていません".length());
        assertEquals(resultMessage.getOutboundProperty(HttpConnector.HTTP_STATUS_PROPERTY),
        						500);
        assertEquals(resultMessage.getOutboundProperty(MuleProperties.MULE_ENCODING_PROPERTY),
        						"Shift_jis");
	}

}
