package jp.co.ogis_ri.citk.common.transformer.http;

import static org.junit.Assert.*;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import jp.co.ogis_ri.citk.common.transformer.http.CopyMessagePropertiesTransformer;

import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.PropertyScope;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;


public class CopyMessagePropertiesTransformerTestCase extends AbstractMuleContextTestCase
{
	private static String encoding = "UTF-8";
	private static String path = "/acs";
	private static final String PAYLOAD = "http body!";
	private static Map<String, Object>  messageProperties;
	
	static
	{
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(HttpConnector.HTTP_METHOD_PROPERTY, "GET");
		map.put(HttpConstants.HEADER_ACCEPT, "text/html, application/xhtml+xml, */*");
		map.put(HttpConstants.HEADER_ACCEPT_LANGUAGE, "ja,en-US;q=0.8,en;q=0.6");
		map.put(HttpConstants.HEADER_CONNECTION, "Keep-Alive");
		map.put(HttpConstants.HEADER_HOST,  "www.acme.com");
		map.put(HttpConstants.HEADER_COOKIE, "testCookie=value");
		map.put(HttpConnector.HTTP_CONTEXT_PATH_PROPERTY, "/");
		map.put(HttpConnector.HTTP_REQUEST_PROPERTY, path);
		map.put(HttpConnector.HTTP_REQUEST_PATH_PROPERTY, path);
		map.put(HttpConnector.HTTP_VERSION_PROPERTY, HttpConstants.HTTP11);
		
		messageProperties = Collections.unmodifiableMap(map);
	}
	
	 //setup 時に呼ばれるメソッド。親クラスのテンプレートメソッドをオーバーライドした。
    @Override
    public void doSetUp() throws Exception
    {
        super.doSetUp();
        // トランスフォーマのテストをする際は、必ずRequestContextのイベントが設定されてなければならない。
        RequestContext.setEvent(getTestEvent("test"));
    }

    //tear down 時に呼ばれるメソッド。親クラスのテンプレートメソッドをオーバーライドした。
    @Override
    protected void doTearDown() throws Exception 
    {
        super.doTearDown();
        //RequestContext の値をnullに戻し、次のテストメソッドに備える。
        RequestContext.setEvent(null);
    }

	public Transformer getTransformer() throws Exception {
        Transformer trans = createObject(CopyMessagePropertiesTransformer.class);
        trans.setReturnDataType(DataTypeFactory.create(MuleMessage.class));

        EndpointBuilder builder = new EndpointURIEndpointBuilder("test://test", muleContext);
        builder.setEncoding(encoding);
        ImmutableEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(
            builder);
        trans.setEndpoint(endpoint);
        return trans;
	}


	public Object getTestData() {
		MuleMessage mes = new DefaultMuleMessage(PAYLOAD, messageProperties, null, null, muleContext);
		return mes;
	}


	public Object getResultData() {
		Map<String,Object> map = new HashMap<String, Object>();
		map.putAll(messageProperties);
		map.remove(HttpConstants.HEADER_ACCEPT_ENCODING);
		MuleMessage mes = new DefaultMuleMessage(PAYLOAD, messageProperties, map, null, muleContext);
		return mes;
	}

	@Test
	public void testTransform() throws Exception {
		Transformer trans = this.getTransformer();
        Object result = trans.transform(getTestData());
        Object expectedResult = this.getResultData();
        
		MuleMessage resultMes = (MuleMessage) result;
		
		Map<String, Object> props = new HashMap<String, Object>();
		Set<String> names = resultMes.getPropertyNames(PropertyScope.OUTBOUND);
		
		if(names.contains(HttpConstants.HEADER_ACCEPT_ENCODING))
		{
			fail(HttpConstants.HEADER_ACCEPT_ENCODING + "が含まれています");
		}
		
		for(String name : names)
		{
			props.put(name, resultMes.getOutboundProperty(name));
		}
		
		Map<String,Object> expectedProps = new HashMap<String, Object>();
		expectedProps.putAll(messageProperties);
		expectedProps.remove(HttpConstants.HEADER_ACCEPT_ENCODING);
		
		assertEquals(expectedProps, props);		
	}

}
