/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

import jp.co.ogis_ri.citk.common.CitkConstants;

/**
 * 認可結果ごとのForwarding先のエンドポイント管理クラス実装。
 * @author ISP Shiraishi
 *
 */
public class EndpointUrl {
	private OutboundEndpoint permit; 
	private OutboundEndpoint deny; 
	private OutboundEndpoint indeterminate;
	
	/**
	 * @return permit
	 */
	public OutboundEndpoint getPermit() {
		return permit;
	}

	/**
	 * @param permit セットする permit
	 */
	public void setPermit(OutboundEndpoint permit) {
		this.permit = permit;
	}

	/**
	 * @return deny
	 */
	public OutboundEndpoint getDeny() {
		return deny;
	}

	/**
	 * @param deny セットする deny
	 */
	public void setDeny(OutboundEndpoint deny) {
		this.deny = deny;
	}

	/**
	 * @return indeterminate
	 */
	public OutboundEndpoint getIndeterminate() {
		return indeterminate;
	}

	/**
	 * @param indeterminate セットする indeterminate
	 */
	public void setIndeterminate(OutboundEndpoint indeterminate) {
		this.indeterminate = indeterminate;
	}


	/**
	 * 認可結果ごとのエンドポイントを返却する。
	 * @param authzResult 認可結果
	 * @return　エンドポイント
	 */
	public OutboundEndpoint getOutboundEndpoint(String authzResult) {
		// 判定して返す
		OutboundEndpoint res = null;
		if(authzResult.equals(CitkConstants.AUTHZ_PERMIT)){
			res = permit;
		}
		else if(authzResult.equals(CitkConstants.AUTHZ_DENY)){
			res = deny;
		}
		else if(authzResult.equals(CitkConstants.AUTHZ_INDETERMINATE)){
			res = indeterminate;
		}
		else{
			throw new RuntimeException();
		}
		
		return res;
	}
}
