/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.log.exception.CitkSystemException;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.http.HttpConnector;


/**
 * Mule ESBのフォワーディング処理トランスフォーマークラス実装。
 * @author ISP Shiraishi
 *
 */
public class ForwardingOutboundTransformer extends AbstractMessageTransformer{

	/**
     * カスタムトランスフォーマーのコンストラクタ。
     */
    public ForwardingOutboundTransformer() {
        super();
    }
    
	/**
     * ログメッセージ出力用オブジェクト。
     */
    private static final CitkLogger logger =
    		CitkLogger.getLog(ForwardingOutboundTransformer.class);
	
    /**
    *　アウトバウンド解決クラス
    */
	OutboundEndpointResolver outboundEndpointResolver;
	
	/**
    * アウトバウンド解決クラスのgetter。
    * mule-global-config.xmlにてSpringBeanとして使用している。
    *
    * @return 変換マップ
    */
    public OutboundEndpointResolver getOutboundEndpointResolver() {
		return outboundEndpointResolver;
	}

    /**
    * アウトバウンド解決クラスのsetter。
    * 
    * @param 変換マップ
    */
	public void setOutboundEndpointResolver(
			OutboundEndpointResolver outboundEndpointResolver) {
		this.outboundEndpointResolver = outboundEndpointResolver;
	}
   
    
    @Override
    /**
     *　フォワーディング処理を行う。
     * @param message 変換対象のMuleMessageオブジェクト
     * @param outputEncoding エンコード
     * @return 変換後のMuleMessageオブジェクト
     * @throws TransformerException
     */
    public Object transformMessage(MuleMessage message, String outputEncoding)
                                                   throws TransformerException {	
		String targetKey = null;
		String authzResult = null;
		String path = null;
		try{
			// Resource URI を取得する。（ホスト名は含まない。パスとクエリが含まれる。）
			path = message.getInboundProperty(HttpConnector.HTTP_REQUEST_PROPERTY);
			
			// Authzコンポーネントから結果を受け取る
			authzResult = message.getInboundProperty(CitkConstants.AUTHZ_RESULT_KEY);
		
			// 先頭の'/' を削除する。 Mule が 余分な'/' をつけてしまうらしい。
			path = path.substring(1);
					
			// getting Service Provide ID and Applicathion Context from Resource URI
			String[] str = path.split("/");
			String spId = str[0];
			String appId = str[1];
			
			targetKey = spId + "/" + appId;
		}
		catch(Exception e){
			throw new CitkSystemException(CitkConstants.ERROR_MSG_NOT_CONTAIN_TARGETKEY, e);
		}
		
		OutboundEndpoint outboundEndpoint;
		try {
			outboundEndpoint = outboundEndpointResolver.resolve(targetKey, authzResult);
		} catch (Exception e1) {
			throw new CitkSystemException(CitkConstants.ERROR_MSG_GET_OUTBOUND_ENDPOINT_FAILUER, e1);
		}
		
		if(outboundEndpoint == null){
			//TODO ラップする例外の検討
			throw new CitkSystemException(CitkConstants.ERROR_MSG_GET_OUTBOUND_ENDPOINT_FAILUER);
		}
							
		String host = outboundEndpoint.getHost();
		String port = ":" + outboundEndpoint.getPort();			
		String appContext = outboundEndpoint.getAppcontext();
		
		String address = null;

		//リクエスト部分の切り出し
		String request = null;
		try{
			request = path.substring(path.indexOf("/") +1);
			request = request.substring(request.indexOf("/") +1);
		}
		catch(Exception e){
			throw new CitkSystemException(CitkConstants.ERROR_MSG_GET_REQUEST_FAILUER, e);
		}
				
		address = host + port + appContext + request;		
		String protocol = outboundEndpoint.getProtocol();
		
		logger.info(CitkConstants.LOG_MSG_PHYSICAL_ADDRESS, protocol + "://" + address);
		
		message.setOutboundProperty(CitkConstants.OUTBOUND_ADDRESS, address);
		message.setOutboundProperty(CitkConstants.OUTBOUND_PROTOCOL, protocol);

		return message;
    }
}
