/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

import java.net.URL;

import jp.co.ogis_ri.citk.common.log.CitkLogger;



/**
 * エンドポイント管理クラス実装。
 * @author ISP Shiraishi
 *
 */
public class OutboundEndpoint {
	private String protocol;
	private String host;
	private int port;
	private String appcontext;
	
	/**
	 * コンストラクタ
	 */
	public OutboundEndpoint() {
		super();
	}

	/**
	 * コンストラクタ
	 * @param url エンドポイントのURL
	 */
	public OutboundEndpoint(URL url) {
		super();
		this.protocol = url.getProtocol();
		this.host = url.getHost();
		this.port = url.getPort();
		this.appcontext = url.getPath();
	}
	
	/**
	 * コンストラクタ
	 * @param protocol エンドポイントのプロトコル
	 * @param host エンドポイントのホスト
	 * @param port エンドポイントのポート
	 * @param appcontext エンドポイントのアプリケーションコンテキスト
	 * @param path エンドポイントのパス
	 * @param method エンドポイントのメソッド
	 */
	public OutboundEndpoint(String protocol, String host, int port, String appcontext,
			String path, String method) {
		super();
		this.protocol = protocol;
		this.host = host;
		this.port = port;
		this.appcontext = appcontext;
	}
	
	/**
     * ログメッセージ出力用オブジェクト。
     */
//    private static final CitkLogger logger =
//    		CitkLogger.getLog(OutboundEndpoint.class);
	
	/**
	 * @return protocol
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @param protocol セットする protocol
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @return host
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host セットする host
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return port
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @param port セットする port
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * @return appcontext
	 */
	public String getAppcontext() {
		return appcontext;
	}

	/**
	 * @param appcontext セットする appcontext
	 */
	public void setAppcontext(String appcontext) {
		this.appcontext = appcontext;
	}

	@Override
	/**
	 * @return アウトバウンドエンドポイント文字列
	 */
	public String toString() {
		String address = protocol + "://" + host + ":" + port + appcontext;
		return address;
	}	
}
