/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

/**
 * Mule ESBのアウトバウンドエンドポイント解決インタフェース。
 * @author ISP Shiraishi
 *
 */
public interface OutboundEndpointResolver {
	
	/**
     * アウトバウンドエンドポイント解決メソッド。
     * （例外は非チェック例外を発生させる）
     * @param targetKey ターゲットリソースを表すキー
     * @param authzResult　認可結果
     * @return エンドポイント情報
     */
	OutboundEndpoint resolve(String targetKey, String authzResult);

}
