/*
 * Copyright (C) 2011 OGIS-RI Co., Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;


/**
 * エンドポイントのMAPビルダークラス実装。
 * @author ISP Shiraishi
 *
 */
public class EndpointUrlBuilder {
	
	/**
     * ログメッセージ出力用オブジェクト。
     */
//    private static final CitkLogger logger =
//    		CitkLogger.getLog(EndpointUrlBuilder.class);
	
	/**
     * エンドポイントマップ。
     */
	private Map<String, String > settingDatas;
	
	/**
	 * @return settingDatas
	 */
	public Map<String, String> getSettingDatas() {
		return settingDatas;
	}

	/**
	 * @param settingDatas セットする settingDatas
	 */
	public void setSettingDatas(Map<String, String> settingDatas) {
		this.settingDatas = settingDatas;
	}


	public Map<String, EndpointUrl> build() throws MalformedURLException {
		Map<String, EndpointUrl> endpointURLMap = new HashMap<String, EndpointUrl>();
		
		
		Set<String> keys = settingDatas.keySet();
		
		for(Iterator i = keys.iterator(); i.hasNext();){
			String name = (String) i.next();
			String[] urls = settingDatas.get(name).split(",");
			
			OutboundEndpoint permit = new OutboundEndpoint(new URL(urls[0]));
			OutboundEndpoint deny = new OutboundEndpoint(new URL(urls[1]));
			OutboundEndpoint indeterminate = new OutboundEndpoint(new URL(urls[2]));
 			
			EndpointUrl endpointUrl = new EndpointUrl();
			
			endpointUrl.setPermit(permit);
			endpointUrl.setDeny(deny);
			endpointUrl.setIndeterminate(indeterminate);
			
			endpointURLMap.put(name, endpointUrl);
		}
		
		return endpointURLMap;
	}
}
